package com.xforceplus.ultraman.app.phoenixkylinservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.phoenixkylinservice.entity.Vehicle;
import com.xforceplus.ultraman.app.phoenixkylinservice.service.IVehicleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-21
 */
@RestController
public class VehicleController {

  @Autowired
  private IVehicleService vehicleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param vehicle ${table.comment}
   * @return
   */
  @GetMapping("/vehicles" )
  public XfR getVehicles(XfPage page, Vehicle vehicle) {
    return XfR.ok(vehicleServiceImpl.page(page, Wrappers.query(vehicle)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/vehicles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(vehicleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param vehicle ${table.comment}
   * @return XfR
   */
  @PostMapping("/vehicles")
  public XfR save(@RequestBody Vehicle vehicle) {
     return XfR.ok(vehicleServiceImpl.save(vehicle));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param vehicle ${table.comment}
   * @return XfR
   */
  @PutMapping("/vehicles/{id}")
  public XfR putUpdate(@RequestBody Vehicle vehicle,@PathVariable Long id) {
      vehicle.setId(id);
      return XfR.ok(vehicleServiceImpl.updateById(vehicle));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param vehicle ${table.comment}
   * @return XfR
   */
  @PatchMapping("/vehicles/{id}")
  public XfR patchUpdate(@RequestBody Vehicle vehicle,@PathVariable Long id) {
      Vehicle upvehicle = vehicleServiceImpl.getById(id);
      if(upvehicle != null){
        upvehicle = ObjectCopyUtils.copyProperties(vehicle,upvehicle,true);
      }
      return XfR.ok(vehicleServiceImpl.updateById(upvehicle));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/vehicles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(vehicleServiceImpl.removeById(id));
  }

  @PostMapping("/vehicles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "vehicle");
     params.put("request", condition);

     return XfR.ok(vehicleServiceImpl.querys(params));
  }

}
