package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 京东账单feign客户端
 *
 * @author ultraman
 * @date 2024-10-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.JdCheck;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface JdCheckFeignApi {

  /**
   * 通过id查询京东账单
   * @param  id
   * @return R
   */
  @GetMapping("/jdCheck/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增京东账单
   * @param jdCheck 京东账单
   * @return R
   */
  @PostMapping("/jdCheck/add")
  public R save(@RequestBody JdCheck jdCheck);

  /**
   * 修改京东账单
   * @param jdCheck 京东账单
   * @return R
   */
  @PostMapping("/jdCheck/update")
  public R updateById(@RequestBody JdCheck jdCheck);

  /**
   * 通过id删除京东账单
   * @param  id
   * @return R
   */
  @DeleteMapping("/jdCheck/del/{id}" )
  public R removeById(@PathVariable Long id);

}