package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 用户系统对象feign客户端
 *
 * @author ultraman
 * @date 2024-10-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SystemUser;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SystemUserFeignApi {

  /**
   * 通过id查询用户系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemUser/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增用户系统对象
   * @param systemUser 用户系统对象
   * @return R
   */
  @PostMapping("/systemUser/add")
  public R save(@RequestBody SystemUser systemUser);

  /**
   * 修改用户系统对象
   * @param systemUser 用户系统对象
   * @return R
   */
  @PostMapping("/systemUser/update")
  public R updateById(@RequestBody SystemUser systemUser);

  /**
   * 通过id删除用户系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemUser/del/{id}" )
  public R removeById(@PathVariable Long id);

}