package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 网店管家OMS售后明细feign客户端
 *
 * @author ultraman
 * @date 2024-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.OmsAfterSaleDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface OmsAfterSaleDetailFeignApi {

  /**
   * 通过id查询网店管家OMS售后明细
   * @param  id
   * @return R
   */
  @GetMapping("/omsAfterSaleDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增网店管家OMS售后明细
   * @param omsAfterSaleDetail 网店管家OMS售后明细
   * @return R
   */
  @PostMapping("/omsAfterSaleDetail/add")
  public R save(@RequestBody OmsAfterSaleDetail omsAfterSaleDetail);

  /**
   * 修改网店管家OMS售后明细
   * @param omsAfterSaleDetail 网店管家OMS售后明细
   * @return R
   */
  @PostMapping("/omsAfterSaleDetail/update")
  public R updateById(@RequestBody OmsAfterSaleDetail omsAfterSaleDetail);

  /**
   * 通过id删除网店管家OMS售后明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/omsAfterSaleDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}