package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 菜单系统对象feign客户端
 *
 * @author ultraman
 * @date 2024-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SystemMenu;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SystemMenuFeignApi {

  /**
   * 通过id查询菜单系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemMenu/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增菜单系统对象
   * @param systemMenu 菜单系统对象
   * @return R
   */
  @PostMapping("/systemMenu/add")
  public R save(@RequestBody SystemMenu systemMenu);

  /**
   * 修改菜单系统对象
   * @param systemMenu 菜单系统对象
   * @return R
   */
  @PostMapping("/systemMenu/update")
  public R updateById(@RequestBody SystemMenu systemMenu);

  /**
   * 通过id删除菜单系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemMenu/del/{id}" )
  public R removeById(@PathVariable Long id);

}