package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 售后单对账结果feign客户端
 *
 * @author ultraman
 * @date 2024-11-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.AfterSalesOrderCheckResult;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface AfterSalesOrderCheckResultFeignApi {

  /**
   * 通过id查询售后单对账结果
   * @param  id
   * @return R
   */
  @GetMapping("/afterSalesOrderCheckResult/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增售后单对账结果
   * @param afterSalesOrderCheckResult 售后单对账结果
   * @return R
   */
  @PostMapping("/afterSalesOrderCheckResult/add")
  public R save(@RequestBody AfterSalesOrderCheckResult afterSalesOrderCheckResult);

  /**
   * 修改售后单对账结果
   * @param afterSalesOrderCheckResult 售后单对账结果
   * @return R
   */
  @PostMapping("/afterSalesOrderCheckResult/update")
  public R updateById(@RequestBody AfterSalesOrderCheckResult afterSalesOrderCheckResult);

  /**
   * 通过id删除售后单对账结果
   * @param  id
   * @return R
   */
  @DeleteMapping("/afterSalesOrderCheckResult/del/{id}" )
  public R removeById(@PathVariable Long id);

}