package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 抖音结算单feign客户端
 *
 * @author ultraman
 * @date 2024-11-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.DySettlement;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface DySettlementFeignApi {

  /**
   * 通过id查询抖音结算单
   * @param  id
   * @return R
   */
  @GetMapping("/dySettlement/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增抖音结算单
   * @param dySettlement 抖音结算单
   * @return R
   */
  @PostMapping("/dySettlement/add")
  public R save(@RequestBody DySettlement dySettlement);

  /**
   * 修改抖音结算单
   * @param dySettlement 抖音结算单
   * @return R
   */
  @PostMapping("/dySettlement/update")
  public R updateById(@RequestBody DySettlement dySettlement);

  /**
   * 通过id删除抖音结算单
   * @param  id
   * @return R
   */
  @DeleteMapping("/dySettlement/del/{id}" )
  public R removeById(@PathVariable Long id);

}