package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 网店管家OMS售后feign客户端
 *
 * @author ultraman
 * @date 2024-11-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.OmsAfterSale;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface OmsAfterSaleFeignApi {

  /**
   * 通过id查询网店管家OMS售后
   * @param  id
   * @return R
   */
  @GetMapping("/omsAfterSale/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增网店管家OMS售后
   * @param omsAfterSale 网店管家OMS售后
   * @return R
   */
  @PostMapping("/omsAfterSale/add")
  public R save(@RequestBody OmsAfterSale omsAfterSale);

  /**
   * 修改网店管家OMS售后
   * @param omsAfterSale 网店管家OMS售后
   * @return R
   */
  @PostMapping("/omsAfterSale/update")
  public R updateById(@RequestBody OmsAfterSale omsAfterSale);

  /**
   * 通过id删除网店管家OMS售后
   * @param  id
   * @return R
   */
  @DeleteMapping("/omsAfterSale/del/{id}" )
  public R removeById(@PathVariable Long id);

}