package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 拼多多账单feign客户端
 *
 * @author ultraman
 * @date 2024-11-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.PddCheck;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface PddCheckFeignApi {

  /**
   * 通过id查询拼多多账单
   * @param  id
   * @return R
   */
  @GetMapping("/pddCheck/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增拼多多账单
   * @param pddCheck 拼多多账单
   * @return R
   */
  @PostMapping("/pddCheck/add")
  public R save(@RequestBody PddCheck pddCheck);

  /**
   * 修改拼多多账单
   * @param pddCheck 拼多多账单
   * @return R
   */
  @PostMapping("/pddCheck/update")
  public R updateById(@RequestBody PddCheck pddCheck);

  /**
   * 通过id删除拼多多账单
   * @param  id
   * @return R
   */
  @DeleteMapping("/pddCheck/del/{id}" )
  public R removeById(@PathVariable Long id);

}