package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 对账配置feign客户端
 *
 * @author ultraman
 * @date 2024-11-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.CheckConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface CheckConfigFeignApi {

  /**
   * 通过id查询对账配置
   * @param  id
   * @return R
   */
  @GetMapping("/checkConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增对账配置
   * @param checkConfig 对账配置
   * @return R
   */
  @PostMapping("/checkConfig/add")
  public R save(@RequestBody CheckConfig checkConfig);

  /**
   * 修改对账配置
   * @param checkConfig 对账配置
   * @return R
   */
  @PostMapping("/checkConfig/update")
  public R updateById(@RequestBody CheckConfig checkConfig);

  /**
   * 通过id删除对账配置
   * @param  id
   * @return R
   */
  @DeleteMapping("/checkConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}