package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 京东结算单feign客户端
 *
 * @author ultraman
 * @date 2024-11-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.JdSettlement;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface JdSettlementFeignApi {

  /**
   * 通过id查询京东结算单
   * @param  id
   * @return R
   */
  @GetMapping("/jdSettlement/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增京东结算单
   * @param jdSettlement 京东结算单
   * @return R
   */
  @PostMapping("/jdSettlement/add")
  public R save(@RequestBody JdSettlement jdSettlement);

  /**
   * 修改京东结算单
   * @param jdSettlement 京东结算单
   * @return R
   */
  @PostMapping("/jdSettlement/update")
  public R updateById(@RequestBody JdSettlement jdSettlement);

  /**
   * 通过id删除京东结算单
   * @param  id
   * @return R
   */
  @DeleteMapping("/jdSettlement/del/{id}" )
  public R removeById(@PathVariable Long id);

}