package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 应收对账结果feign客户端
 *
 * @author ultraman
 * @date 2024-11-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceivableCheckResult;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface ReceivableCheckResultFeignApi {

  /**
   * 通过id查询应收对账结果
   * @param  id
   * @return R
   */
  @GetMapping("/receivableCheckResult/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应收对账结果
   * @param receivableCheckResult 应收对账结果
   * @return R
   */
  @PostMapping("/receivableCheckResult/add")
  public R save(@RequestBody ReceivableCheckResult receivableCheckResult);

  /**
   * 修改应收对账结果
   * @param receivableCheckResult 应收对账结果
   * @return R
   */
  @PostMapping("/receivableCheckResult/update")
  public R updateById(@RequestBody ReceivableCheckResult receivableCheckResult);

  /**
   * 通过id删除应收对账结果
   * @param  id
   * @return R
   */
  @DeleteMapping("/receivableCheckResult/del/{id}" )
  public R removeById(@PathVariable Long id);

}