package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 抖音账单feign客户端
 *
 * @author ultraman
 * @date 2024-11-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.DyCheck;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface DyCheckFeignApi {

  /**
   * 通过id查询抖音账单
   * @param  id
   * @return R
   */
  @GetMapping("/dyCheck/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增抖音账单
   * @param dyCheck 抖音账单
   * @return R
   */
  @PostMapping("/dyCheck/add")
  public R save(@RequestBody DyCheck dyCheck);

  /**
   * 修改抖音账单
   * @param dyCheck 抖音账单
   * @return R
   */
  @PostMapping("/dyCheck/update")
  public R updateById(@RequestBody DyCheck dyCheck);

  /**
   * 通过id删除抖音账单
   * @param  id
   * @return R
   */
  @DeleteMapping("/dyCheck/del/{id}" )
  public R removeById(@PathVariable Long id);

}