package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 应收对账结果关系feign客户端
 *
 * @author ultraman
 * @date 2024-11-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceivableCheckResultItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface ReceivableCheckResultItemFeignApi {

  /**
   * 通过id查询应收对账结果关系
   * @param  id
   * @return R
   */
  @GetMapping("/receivableCheckResultItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应收对账结果关系
   * @param receivableCheckResultItem 应收对账结果关系
   * @return R
   */
  @PostMapping("/receivableCheckResultItem/add")
  public R save(@RequestBody ReceivableCheckResultItem receivableCheckResultItem);

  /**
   * 修改应收对账结果关系
   * @param receivableCheckResultItem 应收对账结果关系
   * @return R
   */
  @PostMapping("/receivableCheckResultItem/update")
  public R updateById(@RequestBody ReceivableCheckResultItem receivableCheckResultItem);

  /**
   * 通过id删除应收对账结果关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/receivableCheckResultItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}