package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 销售订单对账结果关系feign客户端
 *
 * @author ultraman
 * @date 2024-11-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SalesOrderCheckResultItem;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SalesOrderCheckResultItemFeignApi {

  /**
   * 通过id查询销售订单对账结果关系
   * @param  id
   * @return R
   */
  @GetMapping("/salesOrderCheckResultItem/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销售订单对账结果关系
   * @param salesOrderCheckResultItem 销售订单对账结果关系
   * @return R
   */
  @PostMapping("/salesOrderCheckResultItem/add")
  public R save(@RequestBody SalesOrderCheckResultItem salesOrderCheckResultItem);

  /**
   * 修改销售订单对账结果关系
   * @param salesOrderCheckResultItem 销售订单对账结果关系
   * @return R
   */
  @PostMapping("/salesOrderCheckResultItem/update")
  public R updateById(@RequestBody SalesOrderCheckResultItem salesOrderCheckResultItem);

  /**
   * 通过id删除销售订单对账结果关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesOrderCheckResultItem/del/{id}" )
  public R removeById(@PathVariable Long id);

}