package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 系统枚举扩展对象feign客户端
 *
 * @author ultraman
 * @date 2024-11-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SystemExtendDict;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SystemExtendDictFeignApi {

  /**
   * 通过id查询系统枚举扩展对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemExtendDict/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统枚举扩展对象
   * @param systemExtendDict 系统枚举扩展对象
   * @return R
   */
  @PostMapping("/systemExtendDict/add")
  public R save(@RequestBody SystemExtendDict systemExtendDict);

  /**
   * 修改系统枚举扩展对象
   * @param systemExtendDict 系统枚举扩展对象
   * @return R
   */
  @PostMapping("/systemExtendDict/update")
  public R updateById(@RequestBody SystemExtendDict systemExtendDict);

  /**
   * 通过id删除系统枚举扩展对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemExtendDict/del/{id}" )
  public R removeById(@PathVariable Long id);

}