package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 淘宝账单feign客户端
 *
 * @author ultraman
 * @date 2024-11-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.TbCheck;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface TbCheckFeignApi {

  /**
   * 通过id查询淘宝账单
   * @param  id
   * @return R
   */
  @GetMapping("/tbCheck/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增淘宝账单
   * @param tbCheck 淘宝账单
   * @return R
   */
  @PostMapping("/tbCheck/add")
  public R save(@RequestBody TbCheck tbCheck);

  /**
   * 修改淘宝账单
   * @param tbCheck 淘宝账单
   * @return R
   */
  @PostMapping("/tbCheck/update")
  public R updateById(@RequestBody TbCheck tbCheck);

  /**
   * 通过id删除淘宝账单
   * @param  id
   * @return R
   */
  @DeleteMapping("/tbCheck/del/{id}" )
  public R removeById(@PathVariable Long id);

}