package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 应收回款核销结果和应收订单关系feign客户端
 *
 * @author ultraman
 * @date 2024-11-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.WriteOffResultItemReceivableOrder;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface WriteOffResultItemReceivableOrderFeignApi {

  /**
   * 通过id查询应收回款核销结果和应收订单关系
   * @param  id
   * @return R
   */
  @GetMapping("/writeOffResultItemReceivableOrder/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应收回款核销结果和应收订单关系
   * @param writeOffResultItemReceivableOrder 应收回款核销结果和应收订单关系
   * @return R
   */
  @PostMapping("/writeOffResultItemReceivableOrder/add")
  public R save(@RequestBody WriteOffResultItemReceivableOrder writeOffResultItemReceivableOrder);

  /**
   * 修改应收回款核销结果和应收订单关系
   * @param writeOffResultItemReceivableOrder 应收回款核销结果和应收订单关系
   * @return R
   */
  @PostMapping("/writeOffResultItemReceivableOrder/update")
  public R updateById(@RequestBody WriteOffResultItemReceivableOrder writeOffResultItemReceivableOrder);

  /**
   * 通过id删除应收回款核销结果和应收订单关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/writeOffResultItemReceivableOrder/del/{id}" )
  public R removeById(@PathVariable Long id);

}