package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 售后单对账履历feign客户端
 *
 * @author ultraman
 * @date 2024-12-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.AfterSalesOrderCheckResultHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface AfterSalesOrderCheckResultHistoryFeignApi {

  /**
   * 通过id查询售后单对账履历
   * @param  id
   * @return R
   */
  @GetMapping("/afterSalesOrderCheckResultHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增售后单对账履历
   * @param afterSalesOrderCheckResultHistory 售后单对账履历
   * @return R
   */
  @PostMapping("/afterSalesOrderCheckResultHistory/add")
  public R save(@RequestBody AfterSalesOrderCheckResultHistory afterSalesOrderCheckResultHistory);

  /**
   * 修改售后单对账履历
   * @param afterSalesOrderCheckResultHistory 售后单对账履历
   * @return R
   */
  @PostMapping("/afterSalesOrderCheckResultHistory/update")
  public R updateById(@RequestBody AfterSalesOrderCheckResultHistory afterSalesOrderCheckResultHistory);

  /**
   * 通过id删除售后单对账履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/afterSalesOrderCheckResultHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}