package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 快手账单feign客户端
 *
 * @author ultraman
 * @date 2024-12-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.KsCheck;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface KsCheckFeignApi {

  /**
   * 通过id查询快手账单
   * @param  id
   * @return R
   */
  @GetMapping("/ksCheck/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增快手账单
   * @param ksCheck 快手账单
   * @return R
   */
  @PostMapping("/ksCheck/add")
  public R save(@RequestBody KsCheck ksCheck);

  /**
   * 修改快手账单
   * @param ksCheck 快手账单
   * @return R
   */
  @PostMapping("/ksCheck/update")
  public R updateById(@RequestBody KsCheck ksCheck);

  /**
   * 通过id删除快手账单
   * @param  id
   * @return R
   */
  @DeleteMapping("/ksCheck/del/{id}" )
  public R removeById(@PathVariable Long id);

}