package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 应收对账履历feign客户端
 *
 * @author ultraman
 * @date 2024-12-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceivableCheckResultHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface ReceivableCheckResultHistoryFeignApi {

  /**
   * 通过id查询应收对账履历
   * @param  id
   * @return R
   */
  @GetMapping("/receivableCheckResultHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应收对账履历
   * @param receivableCheckResultHistory 应收对账履历
   * @return R
   */
  @PostMapping("/receivableCheckResultHistory/add")
  public R save(@RequestBody ReceivableCheckResultHistory receivableCheckResultHistory);

  /**
   * 修改应收对账履历
   * @param receivableCheckResultHistory 应收对账履历
   * @return R
   */
  @PostMapping("/receivableCheckResultHistory/update")
  public R updateById(@RequestBody ReceivableCheckResultHistory receivableCheckResultHistory);

  /**
   * 通过id删除应收对账履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/receivableCheckResultHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}