package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 销售订单对账履历feign客户端
 *
 * @author ultraman
 * @date 2024-12-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SalesOrderCheckResultHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SalesOrderCheckResultHistoryFeignApi {

  /**
   * 通过id查询销售订单对账履历
   * @param  id
   * @return R
   */
  @GetMapping("/salesOrderCheckResultHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销售订单对账履历
   * @param salesOrderCheckResultHistory 销售订单对账履历
   * @return R
   */
  @PostMapping("/salesOrderCheckResultHistory/add")
  public R save(@RequestBody SalesOrderCheckResultHistory salesOrderCheckResultHistory);

  /**
   * 修改销售订单对账履历
   * @param salesOrderCheckResultHistory 销售订单对账履历
   * @return R
   */
  @PostMapping("/salesOrderCheckResultHistory/update")
  public R updateById(@RequestBody SalesOrderCheckResultHistory salesOrderCheckResultHistory);

  /**
   * 通过id删除销售订单对账履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesOrderCheckResultHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}