package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 应收回款核销履历feign客户端
 *
 * @author ultraman
 * @date 2024-12-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.WriteOffResultHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface WriteOffResultHistoryFeignApi {

  /**
   * 通过id查询应收回款核销履历
   * @param  id
   * @return R
   */
  @GetMapping("/writeOffResultHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应收回款核销履历
   * @param writeOffResultHistory 应收回款核销履历
   * @return R
   */
  @PostMapping("/writeOffResultHistory/add")
  public R save(@RequestBody WriteOffResultHistory writeOffResultHistory);

  /**
   * 修改应收回款核销履历
   * @param writeOffResultHistory 应收回款核销履历
   * @return R
   */
  @PostMapping("/writeOffResultHistory/update")
  public R updateById(@RequestBody WriteOffResultHistory writeOffResultHistory);

  /**
   * 通过id删除应收回款核销履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/writeOffResultHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}