package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 快手结算单feign客户端
 *
 * @author ultraman
 * @date 2025-02-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.KsSettlement;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface KsSettlementFeignApi {

  /**
   * 通过id查询快手结算单
   * @param  id
   * @return R
   */
  @GetMapping("/ksSettlement/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增快手结算单
   * @param ksSettlement 快手结算单
   * @return R
   */
  @PostMapping("/ksSettlement/add")
  public R save(@RequestBody KsSettlement ksSettlement);

  /**
   * 修改快手结算单
   * @param ksSettlement 快手结算单
   * @return R
   */
  @PostMapping("/ksSettlement/update")
  public R updateById(@RequestBody KsSettlement ksSettlement);

  /**
   * 通过id删除快手结算单
   * @param  id
   * @return R
   */
  @DeleteMapping("/ksSettlement/del/{id}" )
  public R removeById(@PathVariable Long id);

}