package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 收款单应收单核销关系feign客户端
 *
 * @author ultraman
 * @date 2025-02-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceiveCollectionWriteOffRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface ReceiveCollectionWriteOffRelationFeignApi {

  /**
   * 通过id查询收款单应收单核销关系
   * @param  id
   * @return R
   */
  @GetMapping("/receiveCollectionWriteOffRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增收款单应收单核销关系
   * @param receiveCollectionWriteOffRelation 收款单应收单核销关系
   * @return R
   */
  @PostMapping("/receiveCollectionWriteOffRelation/add")
  public R save(@RequestBody ReceiveCollectionWriteOffRelation receiveCollectionWriteOffRelation);

  /**
   * 修改收款单应收单核销关系
   * @param receiveCollectionWriteOffRelation 收款单应收单核销关系
   * @return R
   */
  @PostMapping("/receiveCollectionWriteOffRelation/update")
  public R updateById(@RequestBody ReceiveCollectionWriteOffRelation receiveCollectionWriteOffRelation);

  /**
   * 通过id删除收款单应收单核销关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/receiveCollectionWriteOffRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}