package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 应收单&收款单核销汇总表feign客户端
 *
 * @author ultraman
 * @date 2025-02-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.ReceiveCollectionWriteOffSummary;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface ReceiveCollectionWriteOffSummaryFeignApi {

  /**
   * 通过id查询应收单&收款单核销汇总表
   * @param  id
   * @return R
   */
  @GetMapping("/receiveCollectionWriteOffSummary/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应收单&收款单核销汇总表
   * @param receiveCollectionWriteOffSummary 应收单&收款单核销汇总表
   * @return R
   */
  @PostMapping("/receiveCollectionWriteOffSummary/add")
  public R save(@RequestBody ReceiveCollectionWriteOffSummary receiveCollectionWriteOffSummary);

  /**
   * 修改应收单&收款单核销汇总表
   * @param receiveCollectionWriteOffSummary 应收单&收款单核销汇总表
   * @return R
   */
  @PostMapping("/receiveCollectionWriteOffSummary/update")
  public R updateById(@RequestBody ReceiveCollectionWriteOffSummary receiveCollectionWriteOffSummary);

  /**
   * 通过id删除应收单&收款单核销汇总表
   * @param  id
   * @return R
   */
  @DeleteMapping("/receiveCollectionWriteOffSummary/del/{id}" )
  public R removeById(@PathVariable Long id);

}