package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 销售订单对账结果feign客户端
 *
 * @author ultraman
 * @date 2025-02-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.SalesOrderCheckResult;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SalesOrderCheckResultFeignApi {

  /**
   * 通过id查询销售订单对账结果
   * @param  id
   * @return R
   */
  @GetMapping("/salesOrderCheckResult/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增销售订单对账结果
   * @param salesOrderCheckResult 销售订单对账结果
   * @return R
   */
  @PostMapping("/salesOrderCheckResult/add")
  public R save(@RequestBody SalesOrderCheckResult salesOrderCheckResult);

  /**
   * 修改销售订单对账结果
   * @param salesOrderCheckResult 销售订单对账结果
   * @return R
   */
  @PostMapping("/salesOrderCheckResult/update")
  public R updateById(@RequestBody SalesOrderCheckResult salesOrderCheckResult);

  /**
   * 通过id删除销售订单对账结果
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesOrderCheckResult/del/{id}" )
  public R removeById(@PathVariable Long id);

}