package com.xforceplus.ultraman.app.policymanagement.controller;


/**
 * 应收回款核销结果快照feign客户端
 *
 * @author ultraman
 * @date 2025-02-21
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.policymanagement.entity.WriteOffResultSnapshot;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface WriteOffResultSnapshotFeignApi {

  /**
   * 通过id查询应收回款核销结果快照
   * @param  id
   * @return R
   */
  @GetMapping("/writeOffResultSnapshot/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应收回款核销结果快照
   * @param writeOffResultSnapshot 应收回款核销结果快照
   * @return R
   */
  @PostMapping("/writeOffResultSnapshot/add")
  public R save(@RequestBody WriteOffResultSnapshot writeOffResultSnapshot);

  /**
   * 修改应收回款核销结果快照
   * @param writeOffResultSnapshot 应收回款核销结果快照
   * @return R
   */
  @PostMapping("/writeOffResultSnapshot/update")
  public R updateById(@RequestBody WriteOffResultSnapshot writeOffResultSnapshot);

  /**
   * 通过id删除应收回款核销结果快照
   * @param  id
   * @return R
   */
  @DeleteMapping("/writeOffResultSnapshot/del/{id}" )
  public R removeById(@PathVariable Long id);

}