package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 抖音账单
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DyCheck implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 主键
   */
  private Long dyId;

  /**
   * 租户code
   */
  private String dyTenantCode;

  /**
   * 店铺编号
   */
  private String storeId;

  /**
   * 获取账单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acqBillDate;

  /**
   * 动账时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billTime;

  /**
   * 动账方向
   */
  private String fundFlow;

  /**
   * 动账方向描述
   */
  private String fundFlowDesc;

  /**
   * 动账金额
   */
  private BigDecimal accountAmount;

  /**
   * 动账摘要
   */
  private String accountBillDesc;

  /**
   * 动账摘要标签
   */
  private String accountBillDescTag;

  /**
   * 计费类型
   */
  private String bizType;

  /**
   * 计费类型描述
   */
  private String bizTypeDesc;

  /**
   * 订单号
   */
  private String orderId;

  /**
   * 店铺单号
   */
  private String shopOrderId;

  /**
   * 售后单id
   */
  private String afterSaleServiceNo;

  /**
   * 下单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime businessOrderCreateTime;

  /**
   * 商品id
   */
  private String productId;

  /**
   * 订单实付应结
   */
  private BigDecimal payAmount;

  /**
   * 实际平台补贴
   */
  private BigDecimal promotionAmount;

  /**
   * 订单退款
   */
  private BigDecimal refundAmount;

  /**
   * 平台服务费
   */
  private BigDecimal platformServiceFee;

  /**
   * 佣金
   */
  private BigDecimal commission;

  /**
   * 渠道分成
   */
  private BigDecimal channelFee;

  /**
   * 招商服务费
   */
  private BigDecimal colonelServiceFee;

  /**
   * 动账账户
   */
  private String accountType;

  /**
   * 动账账户描述
   */
  private String accountTypeDesc;

  /**
   * 实际达人补贴
   */
  private BigDecimal authorCouponSubsidy;

  /**
   * 运费
   */
  private BigDecimal postAmount;

  /**
   * 动账流水
   */
  private BigDecimal accountTradeNo;

  /**
   * 订单类型
   */
  private String orderType;

  /**
   * 订单类型描述
   */
  private String orderTypeDesc;

  /**
   * 实际抖音支付补贴
   */
  private BigDecimal actualZtPayPromotion;

  /**
   * 实际DOU分期营销补贴
   */
  private BigDecimal actualZrPayPromotion;

  /**
   * 直播间站外推广
   */
  private BigDecimal channelPromotionFee;

  /**
   * 其他分成金额
   */
  private BigDecimal otherSharingAmount;

  /**
   * 备注
   */
  private String remark;

  /**
   * 店铺id
   */
  private String shopId;

  /**
   * 动账场景
   */
  private String transScene;

  /**
   * 动账场景标签
   */
  private String transSceneTag;

  /**
   * 是否免佣
   */
  private String freeCommissionFlag;

  /**
   * 免佣金额
   */
  private BigDecimal realFreeCommissionAmount;

  /**
   * 银行补贴
   */
  private BigDecimal bankPayPromotionAmount;

  /**
   * 以旧换新抵扣
   */
  private BigDecimal recyclerAmount;

  /**
   * 平台补贴运费
   */
  private BigDecimal postPromotionAmount;

  /**
   * 服务商佣金
   */
  private BigDecimal partnerCommission;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("dy_id", dyId);
      map.put("dy_tenant_code", dyTenantCode);
      map.put("store_id", storeId);
      map.put("acq_bill_date", BocpGenUtils.toTimestamp(acqBillDate));
      map.put("bill_time", BocpGenUtils.toTimestamp(billTime));
      map.put("fund_flow", fundFlow);
      map.put("fund_flow_desc", fundFlowDesc);
      map.put("account_amount", accountAmount);
      map.put("account_bill_desc", accountBillDesc);
      map.put("account_bill_desc_tag", accountBillDescTag);
      map.put("biz_type", bizType);
      map.put("biz_type_desc", bizTypeDesc);
      map.put("order_id", orderId);
      map.put("shop_order_id", shopOrderId);
      map.put("after_sale_service_no", afterSaleServiceNo);
      map.put("business_order_create_time", BocpGenUtils.toTimestamp(businessOrderCreateTime));
      map.put("product_id", productId);
      map.put("pay_amount", payAmount);
      map.put("promotion_amount", promotionAmount);
      map.put("refund_amount", refundAmount);
      map.put("platform_service_fee", platformServiceFee);
      map.put("commission", commission);
      map.put("channel_fee", channelFee);
      map.put("colonel_service_fee", colonelServiceFee);
      map.put("account_type", accountType);
      map.put("account_type_desc", accountTypeDesc);
      map.put("author_coupon_subsidy", authorCouponSubsidy);
      map.put("post_amount", postAmount);
      map.put("account_trade_no", accountTradeNo);
      map.put("order_type", orderType);
      map.put("order_type_desc", orderTypeDesc);
      map.put("actual_zt_pay_promotion", actualZtPayPromotion);
      map.put("actual_zr_pay_promotion", actualZrPayPromotion);
      map.put("channel_promotion_fee", channelPromotionFee);
      map.put("other_sharing_amount", otherSharingAmount);
      map.put("remark", remark);
      map.put("shop_id", shopId);
      map.put("trans_scene", transScene);
      map.put("trans_scene_tag", transSceneTag);
      map.put("free_commission_flag", freeCommissionFlag);
      map.put("real_free_commission_amount", realFreeCommissionAmount);
      map.put("bank_pay_promotion_amount", bankPayPromotionAmount);
      map.put("recycler_amount", recyclerAmount);
      map.put("post_promotion_amount", postPromotionAmount);
      map.put("partner_commission", partnerCommission);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("business_id", businessId);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("latest", latest);
      map.put("versionNo", versionNo);

      return map;
  }

  public static DyCheck fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    DyCheck entity = new DyCheck();
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dy_tenant_code")) {
      Object obj = map.get("dy_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDyTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcqBillDate(null);
      }
    }
    if(map.containsKey("bill_time")) {
      Object obj = map.get("bill_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillTime(null);
      }
    }
    if(map.containsKey("fund_flow")) {
      Object obj = map.get("fund_flow");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFundFlow((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fund_flow_desc")) {
      Object obj = map.get("fund_flow_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFundFlowDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_amount")) {
      Object obj = map.get("account_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAccountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAccountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAccountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAccountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("account_bill_desc")) {
      Object obj = map.get("account_bill_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountBillDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_bill_desc_tag")) {
      Object obj = map.get("account_bill_desc_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountBillDescTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_type")) {
      Object obj = map.get("biz_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_type_desc")) {
      Object obj = map.get("biz_type_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_order_id")) {
      Object obj = map.get("shop_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("after_sale_service_no")) {
      Object obj = map.get("after_sale_service_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterSaleServiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_order_create_time")) {
      Object obj = map.get("business_order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBusinessOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBusinessOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBusinessOrderCreateTime(null);
      }
    }
    if(map.containsKey("product_id")) {
      Object obj = map.get("product_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_amount")) {
      Object obj = map.get("promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_service_fee")) {
      Object obj = map.get("platform_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("commission")) {
      Object obj = map.get("commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("channel_fee")) {
      Object obj = map.get("channel_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChannelFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChannelFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChannelFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChannelFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChannelFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("colonel_service_fee")) {
      Object obj = map.get("colonel_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setColonelServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setColonelServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setColonelServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setColonelServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setColonelServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("account_type")) {
      Object obj = map.get("account_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_type_desc")) {
      Object obj = map.get("account_type_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("author_coupon_subsidy")) {
      Object obj = map.get("author_coupon_subsidy");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAuthorCouponSubsidy((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAuthorCouponSubsidy(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAuthorCouponSubsidy(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthorCouponSubsidy(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuthorCouponSubsidy(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_amount")) {
      Object obj = map.get("post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("account_trade_no")) {
      Object obj = map.get("account_trade_no");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAccountTradeNo((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAccountTradeNo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAccountTradeNo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountTradeNo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAccountTradeNo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type_desc")) {
      Object obj = map.get("order_type_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actual_zt_pay_promotion")) {
      Object obj = map.get("actual_zt_pay_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualZtPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualZtPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualZtPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualZtPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualZtPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actual_zr_pay_promotion")) {
      Object obj = map.get("actual_zr_pay_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualZrPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualZrPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualZrPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualZrPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualZrPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("channel_promotion_fee")) {
      Object obj = map.get("channel_promotion_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChannelPromotionFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChannelPromotionFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChannelPromotionFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChannelPromotionFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChannelPromotionFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("other_sharing_amount")) {
      Object obj = map.get("other_sharing_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOtherSharingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOtherSharingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOtherSharingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOtherSharingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOtherSharingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trans_scene")) {
      Object obj = map.get("trans_scene");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransScene((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trans_scene_tag")) {
      Object obj = map.get("trans_scene_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransSceneTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("free_commission_flag")) {
      Object obj = map.get("free_commission_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreeCommissionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("real_free_commission_amount")) {
      Object obj = map.get("real_free_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRealFreeCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRealFreeCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRealFreeCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRealFreeCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRealFreeCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bank_pay_promotion_amount")) {
      Object obj = map.get("bank_pay_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBankPayPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBankPayPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBankPayPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBankPayPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBankPayPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recycler_amount")) {
      Object obj = map.get("recycler_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRecyclerAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRecyclerAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRecyclerAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecyclerAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRecyclerAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_promotion_amount")) {
      Object obj = map.get("post_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("partner_commission")) {
      Object obj = map.get("partner_commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPartnerCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPartnerCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPartnerCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPartnerCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPartnerCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("dy_tenant_code")) {
      Object obj = map.get("dy_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDyTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAcqBillDate(null);
      }
    }
    if(map.containsKey("bill_time")) {
      Object obj = map.get("bill_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillTime(null);
      }
    }
    if(map.containsKey("fund_flow")) {
      Object obj = map.get("fund_flow");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFundFlow((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fund_flow_desc")) {
      Object obj = map.get("fund_flow_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFundFlowDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_amount")) {
      Object obj = map.get("account_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAccountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAccountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAccountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAccountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("account_bill_desc")) {
      Object obj = map.get("account_bill_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountBillDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_bill_desc_tag")) {
      Object obj = map.get("account_bill_desc_tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountBillDescTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_type")) {
      Object obj = map.get("biz_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_type_desc")) {
      Object obj = map.get("biz_type_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_order_id")) {
      Object obj = map.get("shop_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("after_sale_service_no")) {
      Object obj = map.get("after_sale_service_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAfterSaleServiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_order_create_time")) {
      Object obj = map.get("business_order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBusinessOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBusinessOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBusinessOrderCreateTime(null);
      }
    }
    if(map.containsKey("product_id")) {
      Object obj = map.get("product_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_amount")) {
      Object obj = map.get("promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("platform_service_fee")) {
      Object obj = map.get("platform_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPlatformServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPlatformServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPlatformServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatformServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPlatformServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("commission")) {
      Object obj = map.get("commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("channel_fee")) {
      Object obj = map.get("channel_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setChannelFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setChannelFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setChannelFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChannelFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setChannelFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("colonel_service_fee")) {
      Object obj = map.get("colonel_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setColonelServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setColonelServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setColonelServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setColonelServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setColonelServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("account_type")) {
      Object obj = map.get("account_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_type_desc")) {
      Object obj = map.get("account_type_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("author_coupon_subsidy")) {
      Object obj = map.get("author_coupon_subsidy");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAuthorCouponSubsidy((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAuthorCouponSubsidy(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAuthorCouponSubsidy(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuthorCouponSubsidy(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAuthorCouponSubsidy(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("post_amount")) {
      Object obj = map.get("post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("account_trade_no")) {
      Object obj = map.get("account_trade_no");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAccountTradeNo((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAccountTradeNo(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAccountTradeNo(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountTradeNo(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAccountTradeNo(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type_desc")) {
      Object obj = map.get("order_type_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("actual_zt_pay_promotion")) {
      Object obj = map.get("actual_zt_pay_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActualZtPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActualZtPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActualZtPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualZtPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActualZtPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("actual_zr_pay_promotion")) {
      Object obj = map.get("actual_zr_pay_promotion");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActualZrPayPromotion((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActualZrPayPromotion(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActualZrPayPromotion(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualZrPayPromotion(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActualZrPayPromotion(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("channel_promotion_fee")) {
      Object obj = map.get("channel_promotion_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setChannelPromotionFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setChannelPromotionFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setChannelPromotionFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChannelPromotionFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setChannelPromotionFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("other_sharing_amount")) {
      Object obj = map.get("other_sharing_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOtherSharingAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOtherSharingAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOtherSharingAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOtherSharingAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOtherSharingAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trans_scene")) {
      Object obj = map.get("trans_scene");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransScene((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trans_scene_tag")) {
      Object obj = map.get("trans_scene_tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransSceneTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("free_commission_flag")) {
      Object obj = map.get("free_commission_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFreeCommissionFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("real_free_commission_amount")) {
      Object obj = map.get("real_free_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRealFreeCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRealFreeCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRealFreeCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRealFreeCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRealFreeCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bank_pay_promotion_amount")) {
      Object obj = map.get("bank_pay_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBankPayPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBankPayPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBankPayPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBankPayPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBankPayPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("recycler_amount")) {
      Object obj = map.get("recycler_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRecyclerAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRecyclerAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRecyclerAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRecyclerAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRecyclerAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("post_promotion_amount")) {
      Object obj = map.get("post_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("partner_commission")) {
      Object obj = map.get("partner_commission");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPartnerCommission((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPartnerCommission(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPartnerCommission(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPartnerCommission(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPartnerCommission(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
  }
}
