package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 快手账单
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class KsCheck implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 主键
   */
  private Long ksId;

  /**
   * 租户code
   */
  private String ksTenantCode;

  /**
   * 店铺编号
   */
  private String storeId;

  /**
   * 获取账单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acqBillDate;

  /**
   * 业务订单号
   */
  private String outOrderId;

  /**
   * 财务流水号
   */
  private String bookTransNo;

  /**
   * 业务类型
   */
  private String bizType;

  /**
   * 业务类型描述
   */
  private String bizTypeDesc;

  /**
   * 交易时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billTime;

  /**
   * 交易时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtBillTime;

  /**
   * 财务方向
   */
  private String inOutType;

  /**
   * 记账金额
   */
  private BigDecimal amount;

  /**
   * 记账后余额
   */
  private BigDecimal balance;

  /**
   * 描述
   */
  private String remark;

  /**
   * 备注
   */
  private String attach;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ks_id", ksId);
      map.put("ks_tenant_code", ksTenantCode);
      map.put("store_id", storeId);
      map.put("acq_bill_date", BocpGenUtils.toTimestamp(acqBillDate));
      map.put("out_order_id", outOrderId);
      map.put("book_trans_no", bookTransNo);
      map.put("biz_type", bizType);
      map.put("biz_type_desc", bizTypeDesc);
      map.put("bill_time", BocpGenUtils.toTimestamp(billTime));
      map.put("gmt_bill_time", BocpGenUtils.toTimestamp(gmtBillTime));
      map.put("in_out_type", inOutType);
      map.put("amount", amount);
      map.put("balance", balance);
      map.put("remark", remark);
      map.put("attach", attach);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);

      return map;
  }

  public static KsCheck fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    KsCheck entity = new KsCheck();
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setKsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcqBillDate(null);
      }
    }
    if(map.containsKey("out_order_id")) {
      Object obj = map.get("out_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOutOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("book_trans_no")) {
      Object obj = map.get("book_trans_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBookTransNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_type")) {
      Object obj = map.get("biz_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("biz_type_desc")) {
      Object obj = map.get("biz_type_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_time")) {
      Object obj = map.get("bill_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillTime(null);
      }
    }
    if(map.containsKey("gmt_bill_time")) {
      Object obj = map.get("gmt_bill_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtBillTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtBillTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtBillTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtBillTime(null);
      }
    }
    if(map.containsKey("in_out_type")) {
      Object obj = map.get("in_out_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInOutType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("balance")) {
      Object obj = map.get("balance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBalance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBalance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBalance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBalance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBalance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attach")) {
      Object obj = map.get("attach");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttach((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setKsId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKsTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAcqBillDate(null);
      }
    }
    if(map.containsKey("out_order_id")) {
      Object obj = map.get("out_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOutOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("book_trans_no")) {
      Object obj = map.get("book_trans_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBookTransNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_type")) {
      Object obj = map.get("biz_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("biz_type_desc")) {
      Object obj = map.get("biz_type_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizTypeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_time")) {
      Object obj = map.get("bill_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillTime(null);
      }
    }
    if(map.containsKey("gmt_bill_time")) {
      Object obj = map.get("gmt_bill_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtBillTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtBillTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtBillTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtBillTime(null);
      }
    }
    if(map.containsKey("in_out_type")) {
      Object obj = map.get("in_out_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInOutType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("balance")) {
      Object obj = map.get("balance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBalance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBalance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBalance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBalance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBalance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attach")) {
      Object obj = map.get("attach");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttach((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
  }
}
