package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_order_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-29
 */
public enum KsOrderStatus {

    _0("0", "未知状态"),
    _10("10", "待付款"),
    _30("30", "已付款"),
    _40("40", "已发货"),
    _50("50", "已签收"),
    _70("70", "订单成功"),
    _80("80", "订单失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    KsOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsOrderStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "10":
                return _10;
            case "30":
                return _30;
            case "40":
                return _40;
            case "50":
                return _50;
            case "70":
                return _70;
            case "80":
                return _80;
            default:
                return null;
        }
    }
}
