package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * source_channel
 * </p>
 *
 * @author ultraman
 * @since 2024-10-30
 */
public enum SourceChannel {

    JD("JD", "京东"),
    PDD("PDD", "拼多多"),
    KS("KS", "快手"),
    DY("DY", "抖音"),
    TM("TM", "天猫");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SourceChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SourceChannel fromCode(String code){
        switch(code) {
            case "JD":
                return JD;
            case "PDD":
                return PDD;
            case "KS":
                return KS;
            case "DY":
                return DY;
            case "TM":
                return TM;
            default:
                return null;
        }
    }
}
