package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-10-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DySalesOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 抖音id
   */
  private Long dyId;

  /**
   * 订单编号
   */
  private String orderId;

  /**
   * 支付时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payTime;

  /**
   * 达人抖音号
   */
  private String awemeId;

  /**
   * 达人昵称名称
   */
  private String userNickName;

  /**
   * 订单类型
   */
  private String orderType;

  /**
   * 订单状态
   */
  private String orderStatus;

  /**
   * 订单完成时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime finishTime;

  /**
   * 下单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dyCreateTime;

  /**
   * 订单更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dyUpdateTime;

  /**
   * 取消原因
   */
  private String cancelReason;

  /**
   * 买家留言
   */
  private String buyerWords;

  /**
   * 商家备注
   */
  private String sellerWords;

  /**
   * 支付类型
   */
  private String payType;

  /**
   * 支付渠道的流水号
   */
  private String channelPaymentNo;

  /**
   * 订单金额
   */
  private BigDecimal orderAmount;

  /**
   * 支付金额
   */
  private BigDecimal payAmount;

  /**
   * 快递费
   */
  private BigDecimal postAmount;

  /**
   * 运费险金额
   */
  private BigDecimal postInsuranceAmount;

  /**
   * 改价金额变化量
   */
  private Long modifyAmount;

  /**
   * 改价运费金额变化量
   */
  private Long modifyPostAmount;

  /**
   * 订单优惠总金额
   */
  private BigDecimal promotionAmount;

  /**
   * 店铺优惠金额
   */
  private BigDecimal promotionShopAmount;

  /**
   * 平台优惠金额
   */
  private BigDecimal promotionPlatformAmount;

  /**
   * 商家承担金额
   */
  private BigDecimal shopCostAmount;

  /**
   * 平台承担金额
   */
  private BigDecimal platformCostAmount;

  /**
   * 达人优惠金额
   */
  private BigDecimal promotionTalentAmount;

  /**
   * 支付优惠金额
   */
  private BigDecimal promotionPayAmount;

  /**
   * 收货省份
   */
  private String deliveryProvince;

  /**
   * 收货城市
   */
  private String deliveryCity;

  /**
   * 收货区域
   */
  private String deliveryDistrict;

  /**
   * 收货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime shipTime;

  /**
   * 用户唯一id
   */
  private String doudianOpenId;

  /**
   * 红包优惠金额
   */
  private BigDecimal promotionRedpackAmount;

  /**
   * 平台红包优惠金额
   */
  private BigDecimal promotionRedpackPlatformAmount;

  /**
   * 总优惠金额
   */
  private BigDecimal promotionRedpackTalentAmount;

  /**
   * 总优惠金额
   */
  private BigDecimal totalPromotionAmount;

  /**
   * 运费原价
   */
  private BigDecimal postOriginAmount;

  /**
   * 运费优惠金额
   */
  private BigDecimal postPromotionAmount;

  /**
   * 作者（达人）承担金额
   */
  private BigDecimal authorCostAmount;

  /**
   * 仅平台承担金额
   */
  private BigDecimal onlyPlatformCostAmount;

  /**
   * 税费
   */
  private BigDecimal taxAmount;

  /**
   * 系统记录更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sysUpdateTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 店铺编号
   */
  private String shopId;

  /**
   * 单据流转状态
   */
  private String dealStatus;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("dy_id", dyId);
      map.put("order_id", orderId);
      map.put("pay_time", BocpGenUtils.toTimestamp(payTime));
      map.put("aweme_id", awemeId);
      map.put("user_nick_name", userNickName);
      map.put("order_type", orderType);
      map.put("order_status", orderStatus);
      map.put("finish_time", BocpGenUtils.toTimestamp(finishTime));
      map.put("dy_create_time", BocpGenUtils.toTimestamp(dyCreateTime));
      map.put("dy_update_time", BocpGenUtils.toTimestamp(dyUpdateTime));
      map.put("cancel_reason", cancelReason);
      map.put("buyer_words", buyerWords);
      map.put("seller_words", sellerWords);
      map.put("pay_type", payType);
      map.put("channel_payment_no", channelPaymentNo);
      map.put("order_amount", orderAmount);
      map.put("pay_amount", payAmount);
      map.put("post_amount", postAmount);
      map.put("post_insurance_amount", postInsuranceAmount);
      map.put("modify_amount", modifyAmount);
      map.put("modify_post_amount", modifyPostAmount);
      map.put("promotion_amount", promotionAmount);
      map.put("promotion_shop_amount", promotionShopAmount);
      map.put("promotion_platform_amount", promotionPlatformAmount);
      map.put("shop_cost_amount", shopCostAmount);
      map.put("platform_cost_amount", platformCostAmount);
      map.put("promotion_talent_amount", promotionTalentAmount);
      map.put("promotion_pay_amount", promotionPayAmount);
      map.put("delivery_province", deliveryProvince);
      map.put("delivery_city", deliveryCity);
      map.put("delivery_district", deliveryDistrict);
      map.put("ship_time", BocpGenUtils.toTimestamp(shipTime));
      map.put("doudian_open_id", doudianOpenId);
      map.put("promotion_redpack_amount", promotionRedpackAmount);
      map.put("promotion_redpack_platform_amount", promotionRedpackPlatformAmount);
      map.put("promotion_redpack_talent_amount", promotionRedpackTalentAmount);
      map.put("total_promotion_amount", totalPromotionAmount);
      map.put("post_origin_amount", postOriginAmount);
      map.put("post_promotion_amount", postPromotionAmount);
      map.put("author_cost_amount", authorCostAmount);
      map.put("only_platform_cost_amount", onlyPlatformCostAmount);
      map.put("tax_amount", taxAmount);
      map.put("sys_update_time", BocpGenUtils.toTimestamp(sysUpdateTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("shop_id", shopId);
      map.put("deal_status", dealStatus);
      map.put("org_tree", orgTree);

      return map;
  }

  public static DySalesOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    DySalesOrder entity = new DySalesOrder();
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayTime(null);
      }
    }
    if(map.containsKey("aweme_id")) {
      Object obj = map.get("aweme_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAwemeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_nick_name")) {
      Object obj = map.get("user_nick_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserNickName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("finish_time")) {
      Object obj = map.get("finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFinishTime(null);
      }
    }
    if(map.containsKey("dy_create_time")) {
      Object obj = map.get("dy_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDyCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDyCreateTime(null);
      }
    }
    if(map.containsKey("dy_update_time")) {
      Object obj = map.get("dy_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDyUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDyUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDyUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDyUpdateTime(null);
      }
    }
    if(map.containsKey("cancel_reason")) {
      Object obj = map.get("cancel_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCancelReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_words")) {
      Object obj = map.get("buyer_words");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerWords((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_words")) {
      Object obj = map.get("seller_words");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerWords((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel_payment_no")) {
      Object obj = map.get("channel_payment_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChannelPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_amount")) {
      Object obj = map.get("order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_amount")) {
      Object obj = map.get("post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_insurance_amount")) {
      Object obj = map.get("post_insurance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostInsuranceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostInsuranceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostInsuranceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostInsuranceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostInsuranceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("modify_amount")) {
      Object obj = map.get("modify_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModifyAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setModifyAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setModifyAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("modify_post_amount")) {
      Object obj = map.get("modify_post_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setModifyPostAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setModifyPostAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setModifyPostAmount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_amount")) {
      Object obj = map.get("promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_shop_amount")) {
      Object obj = map.get("promotion_shop_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionShopAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionShopAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionShopAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionShopAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionShopAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_platform_amount")) {
      Object obj = map.get("promotion_platform_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionPlatformAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionPlatformAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionPlatformAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionPlatformAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionPlatformAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_cost_amount")) {
      Object obj = map.get("shop_cost_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShopCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShopCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShopCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShopCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShopCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_cost_amount")) {
      Object obj = map.get("platform_cost_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_talent_amount")) {
      Object obj = map.get("promotion_talent_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionTalentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionTalentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionTalentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionTalentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionTalentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_pay_amount")) {
      Object obj = map.get("promotion_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("delivery_province")) {
      Object obj = map.get("delivery_province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_city")) {
      Object obj = map.get("delivery_city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_district")) {
      Object obj = map.get("delivery_district");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryDistrict((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ship_time")) {
      Object obj = map.get("ship_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShipTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setShipTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShipTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setShipTime(null);
      }
    }
    if(map.containsKey("doudian_open_id")) {
      Object obj = map.get("doudian_open_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDoudianOpenId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("promotion_redpack_amount")) {
      Object obj = map.get("promotion_redpack_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionRedpackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionRedpackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionRedpackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionRedpackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionRedpackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_redpack_platform_amount")) {
      Object obj = map.get("promotion_redpack_platform_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionRedpackPlatformAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionRedpackPlatformAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionRedpackPlatformAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionRedpackPlatformAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionRedpackPlatformAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_redpack_talent_amount")) {
      Object obj = map.get("promotion_redpack_talent_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionRedpackTalentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionRedpackTalentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionRedpackTalentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionRedpackTalentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionRedpackTalentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_promotion_amount")) {
      Object obj = map.get("total_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_origin_amount")) {
      Object obj = map.get("post_origin_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostOriginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostOriginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostOriginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostOriginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostOriginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_promotion_amount")) {
      Object obj = map.get("post_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("author_cost_amount")) {
      Object obj = map.get("author_cost_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAuthorCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAuthorCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAuthorCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuthorCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuthorCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("only_platform_cost_amount")) {
      Object obj = map.get("only_platform_cost_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOnlyPlatformCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOnlyPlatformCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOnlyPlatformCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOnlyPlatformCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOnlyPlatformCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sys_update_time")) {
      Object obj = map.get("sys_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSysUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSysUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSysUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSysUpdateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("dy_id")) {
      Object obj = map.get("dy_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setDyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayTime(null);
      }
    }
    if(map.containsKey("aweme_id")) {
      Object obj = map.get("aweme_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAwemeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("user_nick_name")) {
      Object obj = map.get("user_nick_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserNickName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_type")) {
      Object obj = map.get("order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("finish_time")) {
      Object obj = map.get("finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setFinishTime(null);
      }
    }
    if(map.containsKey("dy_create_time")) {
      Object obj = map.get("dy_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDyCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDyCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDyCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDyCreateTime(null);
      }
    }
    if(map.containsKey("dy_update_time")) {
      Object obj = map.get("dy_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDyUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDyUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDyUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDyUpdateTime(null);
      }
    }
    if(map.containsKey("cancel_reason")) {
      Object obj = map.get("cancel_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCancelReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_words")) {
      Object obj = map.get("buyer_words");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerWords((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_words")) {
      Object obj = map.get("seller_words");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerWords((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("channel_payment_no")) {
      Object obj = map.get("channel_payment_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChannelPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_amount")) {
      Object obj = map.get("order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("post_amount")) {
      Object obj = map.get("post_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("post_insurance_amount")) {
      Object obj = map.get("post_insurance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostInsuranceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostInsuranceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostInsuranceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostInsuranceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostInsuranceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("modify_amount")) {
      Object obj = map.get("modify_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setModifyAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setModifyAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setModifyAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("modify_post_amount")) {
      Object obj = map.get("modify_post_amount");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setModifyPostAmount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setModifyPostAmount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setModifyPostAmount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_amount")) {
      Object obj = map.get("promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_shop_amount")) {
      Object obj = map.get("promotion_shop_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionShopAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionShopAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionShopAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionShopAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionShopAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_platform_amount")) {
      Object obj = map.get("promotion_platform_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionPlatformAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionPlatformAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionPlatformAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionPlatformAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionPlatformAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shop_cost_amount")) {
      Object obj = map.get("shop_cost_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setShopCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setShopCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setShopCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShopCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setShopCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("platform_cost_amount")) {
      Object obj = map.get("platform_cost_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPlatformCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPlatformCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPlatformCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatformCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPlatformCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_talent_amount")) {
      Object obj = map.get("promotion_talent_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionTalentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionTalentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionTalentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionTalentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionTalentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_pay_amount")) {
      Object obj = map.get("promotion_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("delivery_province")) {
      Object obj = map.get("delivery_province");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delivery_city")) {
      Object obj = map.get("delivery_city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delivery_district")) {
      Object obj = map.get("delivery_district");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryDistrict((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ship_time")) {
      Object obj = map.get("ship_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setShipTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setShipTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShipTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setShipTime(null);
      }
    }
    if(map.containsKey("doudian_open_id")) {
      Object obj = map.get("doudian_open_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDoudianOpenId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("promotion_redpack_amount")) {
      Object obj = map.get("promotion_redpack_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionRedpackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionRedpackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionRedpackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionRedpackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionRedpackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_redpack_platform_amount")) {
      Object obj = map.get("promotion_redpack_platform_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionRedpackPlatformAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionRedpackPlatformAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionRedpackPlatformAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionRedpackPlatformAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionRedpackPlatformAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_redpack_talent_amount")) {
      Object obj = map.get("promotion_redpack_talent_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionRedpackTalentAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionRedpackTalentAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionRedpackTalentAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionRedpackTalentAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionRedpackTalentAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total_promotion_amount")) {
      Object obj = map.get("total_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("post_origin_amount")) {
      Object obj = map.get("post_origin_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostOriginAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostOriginAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostOriginAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostOriginAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostOriginAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("post_promotion_amount")) {
      Object obj = map.get("post_promotion_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostPromotionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostPromotionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostPromotionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostPromotionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostPromotionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("author_cost_amount")) {
      Object obj = map.get("author_cost_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAuthorCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAuthorCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAuthorCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuthorCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAuthorCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("only_platform_cost_amount")) {
      Object obj = map.get("only_platform_cost_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOnlyPlatformCostAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOnlyPlatformCostAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOnlyPlatformCostAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOnlyPlatformCostAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOnlyPlatformCostAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sys_update_time")) {
      Object obj = map.get("sys_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSysUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSysUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSysUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSysUpdateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
