package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 京东账单
 * </p>
 *
 * @author ultraman
 * @since 2024-10-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class JdCheck implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 主键
   */
  private Long jdId;

  /**
   * 租户code
   */
  private String jdTenantCode;

  /**
   * 店铺编号
   */
  private String storeId;

  /**
   * 获取账单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acqBillDate;

  /**
   * 商户号
   */
  private String merchantNo;

  /**
   * 账户代码
   */
  private String accountCode;

  /**
   * 账户名称
   */
  private String accountName;

  /**
   * 日期
   */
  private String billTime;

  /**
   * 商户订单号
   */
  private String merchantOrderNo;

  /**
   * 账户余额(元)
   */
  private BigDecimal accountBalance;

  /**
   * 收入金额(元)
   */
  private BigDecimal receiveAmount;

  /**
   * 支出金额(元)
   */
  private BigDecimal payAmount;

  /**
   * 资金动账备注
   */
  private String remark;

  /**
   * 账单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billDate;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("jd_id", jdId);
      map.put("jd_tenant_code", jdTenantCode);
      map.put("store_id", storeId);
      map.put("acq_bill_date", BocpGenUtils.toTimestamp(acqBillDate));
      map.put("merchant_no", merchantNo);
      map.put("account_code", accountCode);
      map.put("account_name", accountName);
      map.put("bill_time", billTime);
      map.put("merchant_order_no", merchantOrderNo);
      map.put("account_balance", accountBalance);
      map.put("receive_amount", receiveAmount);
      map.put("pay_amount", payAmount);
      map.put("remark", remark);
      map.put("bill_date", BocpGenUtils.toTimestamp(billDate));
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);

      return map;
  }

  public static JdCheck fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    JdCheck entity = new JdCheck();
    if(map.containsKey("jd_id")) {
      Object obj = map.get("jd_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJdId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("jd_tenant_code")) {
      Object obj = map.get("jd_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJdTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcqBillDate(null);
      }
    }
    if(map.containsKey("merchant_no")) {
      Object obj = map.get("merchant_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_code")) {
      Object obj = map.get("account_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_time")) {
      Object obj = map.get("bill_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_order_no")) {
      Object obj = map.get("merchant_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_balance")) {
      Object obj = map.get("account_balance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAccountBalance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAccountBalance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAccountBalance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAccountBalance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAccountBalance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receive_amount")) {
      Object obj = map.get("receive_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceiveAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceiveAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceiveAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiveAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_date")) {
      Object obj = map.get("bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillDate(null);
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("jd_id")) {
      Object obj = map.get("jd_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setJdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJdId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setJdId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("jd_tenant_code")) {
      Object obj = map.get("jd_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJdTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAcqBillDate(null);
      }
    }
    if(map.containsKey("merchant_no")) {
      Object obj = map.get("merchant_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMerchantNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_code")) {
      Object obj = map.get("account_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_time")) {
      Object obj = map.get("bill_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("merchant_order_no")) {
      Object obj = map.get("merchant_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMerchantOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_balance")) {
      Object obj = map.get("account_balance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAccountBalance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAccountBalance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAccountBalance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAccountBalance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAccountBalance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("receive_amount")) {
      Object obj = map.get("receive_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceiveAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceiveAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceiveAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceiveAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceiveAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_date")) {
      Object obj = map.get("bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillDate(null);
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
  }
}
