package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * bill_change_record_source
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
public enum BillChangeRecordSource {

    _10("10", "天猫订单"),
    _20("20", "京东订单"),
    _30("30", "拼多多订单"),
    _40("40", "抖音订单"),
    _50("50", "快手订单"),
    _60("60", "OMS订单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillChangeRecordSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillChangeRecordSource fromCode(String code){
        switch(code) {
            case "10":
                return _10;
            case "20":
                return _20;
            case "30":
                return _30;
            case "40":
                return _40;
            case "50":
                return _50;
            case "60":
                return _60;
            default:
                return null;
        }
    }
}
