package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * documents_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
public enum DocumentsType {

    _1("1", "汇总应收单"),
    _2("2", "汇总收款单"),
    _3("3", "汇总收款单（收入项）"),
    _4("4", "汇总收款单（费用项）"),
    _5("5", "汇总收款单（其他）"),
    _6("6", "汇总收款单（合同负债）"),
    _7("7", "汇总平台补贴单"),
    _8("8", "汇总应收调整单"),
    _9("9", "费用单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocumentsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentsType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
