package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_refund_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
public enum DyRefundStatus {

    _1("1", "待退款"),
    _2("2", "退款中"),
    _3("3", "退款成功"),
    _4("4", "退款失败"),
    _5("5", "追缴成功"),
    _0("0", "无需退款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyRefundStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyRefundStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
