package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_pay_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
public enum JkyPayStatus {

    _0("0", "未付款"),
    _5("5", "部分付款"),
    _9("9", "已付款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JkyPayStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyPayStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "5":
                return _5;
            case "9":
                return _9;
            default:
                return null;
        }
    }
}
