package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * positive_negative
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
public enum PositiveNegative {

    _1("1", "正数"),
    _2("2", "负数");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PositiveNegative(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PositiveNegative fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
