package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_order_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
public enum DyCheckOrderType {

    _0("0", "普通订单"),
    _1("1", "定金(已退款)"),
    _2("2", "定金(尾款已支付)"),
    _3("3", "定金(尾款未支付)"),
    _4("4", "尾款(尾款已支付)"),
    _5("5", "尾款(已退款)");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyCheckOrderType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckOrderType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
