package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * handle_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
public enum HandleType {

    JSONPATH("jsonpath", "jsonpath"),
    JS("js", "js");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    HandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleType fromCode(String code){
        switch(code) {
            case "jsonpath":
                return JSONPATH;
            case "js":
                return JS;
            default:
                return null;
        }
    }
}
