package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_pay_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
public enum KsPayType {

    _0("0", "未知"),
    _1("1", "微信"),
    _2("2", "支付宝"),
    _3("3", "平安"),
    _99("99", "银行转账"),
    _88("88", "支付宝先用后付");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    KsPayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsPayType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "99":
                return _99;
            case "88":
                return _88;
            default:
                return null;
        }
    }
}
