package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OmsOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * OMS id
   */
  private String omsId;

  /**
   * 单号ID
   */
  private String tradeId;

  /**
   * 登记时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime regTime;

  /**
   * 登记人
   */
  private String regOperator;

  /**
   * 交易时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tradeTime;

  /**
   * 订单状态
   */
  private String tradeStatus;

  /**
   * 管家订单号
   */
  private String tradeNo;

  /**
   * 店铺id
   */
  private String shopId;

  /**
   * 仓库id
   */
  private String warehouseId;

  /**
   * 业务员
   */
  private String seller;

  /**
   * 订单类型
   */
  private String tradeType;

  /**
   * 原始单号
   */
  private String tradeNo2;

  /**
   * 店铺名
   */
  private String shopName;

  /**
   * 仓库名
   */
  private String warehouseName;

  /**
   * 仓库编号
   */
  private String warehouseNo;

  /**
   * 物流id
   */
  private String logisticId;

  /**
   * 物流编号
   */
  private String logisticlistNo;

  /**
   * 物流名称
   */
  private String logisticName;

  /**
   * 快递单号
   */
  private String postId;

  /**
   * 货款合计
   */
  private BigDecimal goodsTotal;

  /**
   * 应收邮资
   */
  private BigDecimal postageTotal;

  /**
   * 客付税额
   */
  private BigDecimal taxValue;

  /**
   * 抵扣金额
   */
  private BigDecimal couponValue;

  /**
   * 优惠金额
   */
  private BigDecimal favourableTotal;

  /**
   * 合计应收
   */
  private BigDecimal allTotal;

  /**
   * 实际结算
   */
  private BigDecimal rcvTotal;

  /**
   * 货品成本
   */
  private BigDecimal goodsCost;

  /**
   * 货品重量
   */
  private BigDecimal goodsWeight;

  /**
   * 其他成本
   */
  private BigDecimal otherCost;

  /**
   * 订单利润
   */
  private BigDecimal totalProfit;

  /**
   * 交易佣金
   */
  private BigDecimal commissionValue;

  /**
   * 买家留言
   */
  private String customerRemark;

  /**
   * 客服备注
   */
  private String remark;

  /**
   * 取消原因
   */
  private String cancelReason;

  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime confirmTime;

  /**
   * 审核人
   */
  private String confirmOperator;

  /**
   * 发货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sndTime;

  /**
   * 发货人
   */
  private String sndOperator;

  /**
   * 发票抬头
   */
  private String invoiceTitle;

  /**
   * 不开发票
   */
  private Long binVoice;

  /**
   * 实际邮资
   */
  private BigDecimal postage;

  /**
   * 平台类型
   */
  private String shopType;

  /**
   * 结算方式
   */
  private String chargeType;

  /**
   * 客户ID
   */
  private String customerId;

  /**
   * 国家
   */
  private String country;

  /**
   * 省
   */
  private String province;

  /**
   * 市
   */
  private String city;

  /**
   * 区/县
   */
  private String town;

  /**
   * 邮编
   */
  private String zip;

  /**
   * 自定义字段1
   */
  private String reserved1;

  /**
   * 自定义字段2
   */
  private String reserved2;

  /**
   * 自定义字段3
   */
  private String reserved3;

  /**
   * 自定义字段4
   */
  private String reserved4;

  /**
   * charge_id
   */
  private String chargeId;

  /**
   * 验货人
   */
  private String chkOperator;

  /**
   * 汇率
   */
  private BigDecimal currencyRate;

  /**
   * 币种
   */
  private String currencyType;

  /**
   * 冻结原因
   */
  private String freezeReason;

  /**
   * 包裹重量
   */
  private BigDecimal packagedWeight;

  /**
   * 拣货员
   */
  private String packageOperator;

  /**
   * 供应商
   */
  private String picker;

  /**
   * 供应商ID
   */
  private String providerId;

  /**
   * 供应商名称
   */
  private String providerName;

  /**
   * 供应商编号
   */
  private String providerNo;

  /**
   * 订单来源
   */
  private String tradeFrom;

  /**
   * 订单的标记名称
   */
  private String flagName;

  /**
   * 消费者电话
   */
  private String invoicePayerPhone;

  /**
   * 消费者地址
   */
  private String invoicePayerAddr;

  /**
   * 消费者银行卡号
   */
  private String invoicePayerBankNo;

  /**
   * 税号
   */
  private String invoicePayerRegNo;

  /**
   * 包装名称
   */
  private String packageName;

  /**
   * 电话
   */
  private String tel;

  /**
   * 收件人
   */
  private String sndTo;

  /**
   * 客户网名
   */
  private String tradeNick;

  /**
   * 收货地址
   */
  private String adr;

  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 证件号
   */
  private String idCard;

  /**
   * 证件名称
   */
  private String cardName;

  /**
   * 订单类型
   */
  private String type;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime omsCreateTime;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime omsUpdateTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 对账流转状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 数据来源平台
   */
  @TableField("dataSource")
  private String dataSource;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 数据流转状态
   */
  private String dealStatus;

  /**
   * 验货时间
   */
  private String chkTime;

  /**
   * 激活日期
   */
  private String predate;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 对账金额
   */
  @TableField("checkAmount")
  private BigDecimal checkAmount;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("oms_id", omsId);
      map.put("trade_id", tradeId);
      map.put("reg_time", BocpGenUtils.toTimestamp(regTime));
      map.put("reg_operator", regOperator);
      map.put("trade_time", BocpGenUtils.toTimestamp(tradeTime));
      map.put("trade_status", tradeStatus);
      map.put("trade_no", tradeNo);
      map.put("shop_id", shopId);
      map.put("warehouse_id", warehouseId);
      map.put("seller", seller);
      map.put("trade_type", tradeType);
      map.put("trade_no2", tradeNo2);
      map.put("shop_name", shopName);
      map.put("warehouse_name", warehouseName);
      map.put("warehouse_no", warehouseNo);
      map.put("logistic_id", logisticId);
      map.put("logisticlist_no", logisticlistNo);
      map.put("logistic_name", logisticName);
      map.put("post_id", postId);
      map.put("goods_total", goodsTotal);
      map.put("postage_total", postageTotal);
      map.put("tax_value", taxValue);
      map.put("coupon_value", couponValue);
      map.put("favourable_total", favourableTotal);
      map.put("all_total", allTotal);
      map.put("rcv_total", rcvTotal);
      map.put("goods_cost", goodsCost);
      map.put("goods_weight", goodsWeight);
      map.put("other_cost", otherCost);
      map.put("total_profit", totalProfit);
      map.put("commission_value", commissionValue);
      map.put("customer_remark", customerRemark);
      map.put("remark", remark);
      map.put("cancel_reason", cancelReason);
      map.put("confirm_time", BocpGenUtils.toTimestamp(confirmTime));
      map.put("confirm_operator", confirmOperator);
      map.put("snd_time", BocpGenUtils.toTimestamp(sndTime));
      map.put("snd_operator", sndOperator);
      map.put("invoice_title", invoiceTitle);
      map.put("bin_voice", binVoice);
      map.put("postage", postage);
      map.put("shop_type", shopType);
      map.put("charge_type", chargeType);
      map.put("customer_id", customerId);
      map.put("country", country);
      map.put("province", province);
      map.put("city", city);
      map.put("town", town);
      map.put("zip", zip);
      map.put("reserved1", reserved1);
      map.put("reserved2", reserved2);
      map.put("reserved3", reserved3);
      map.put("reserved4", reserved4);
      map.put("charge_id", chargeId);
      map.put("chk_operator", chkOperator);
      map.put("currency_rate", currencyRate);
      map.put("currency_type", currencyType);
      map.put("freeze_reason", freezeReason);
      map.put("packaged_weight", packagedWeight);
      map.put("package_operator", packageOperator);
      map.put("picker", picker);
      map.put("provider_id", providerId);
      map.put("provider_name", providerName);
      map.put("provider_no", providerNo);
      map.put("trade_from", tradeFrom);
      map.put("flag_name", flagName);
      map.put("invoice_payer_phone", invoicePayerPhone);
      map.put("invoice_payer_addr", invoicePayerAddr);
      map.put("invoice_payer_bank_no", invoicePayerBankNo);
      map.put("invoice_payer_reg_no", invoicePayerRegNo);
      map.put("package_name", packageName);
      map.put("tel", tel);
      map.put("snd_to", sndTo);
      map.put("trade_nick", tradeNick);
      map.put("adr", adr);
      map.put("card_type", cardType);
      map.put("id_card", idCard);
      map.put("card_name", cardName);
      map.put("type", type);
      map.put("oms_create_time", BocpGenUtils.toTimestamp(omsCreateTime));
      map.put("oms_update_time", BocpGenUtils.toTimestamp(omsUpdateTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("business_id", businessId);
      map.put("dataMD5", dataMD5);
      map.put("checkStatus", checkStatus);
      map.put("dataSource", dataSource);
      map.put("error_msg", errorMsg);
      map.put("deal_status", dealStatus);
      map.put("chk_time", chkTime);
      map.put("predate", predate);
      map.put("latest", latest);
      map.put("versionNo", versionNo);
      map.put("checkAmount", checkAmount);
      map.put("org_tree", orgTree);

      return map;
  }

  public static OmsOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OmsOrder entity = new OmsOrder();
    if(map.containsKey("oms_id")) {
      Object obj = map.get("oms_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reg_time")) {
      Object obj = map.get("reg_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRegTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRegTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRegTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRegTime(null);
      }
    }
    if(map.containsKey("reg_operator")) {
      Object obj = map.get("reg_operator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegOperator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_time")) {
      Object obj = map.get("trade_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTradeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTradeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTradeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTradeTime(null);
      }
    }
    if(map.containsKey("trade_status")) {
      Object obj = map.get("trade_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_no")) {
      Object obj = map.get("trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_id")) {
      Object obj = map.get("warehouse_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_no2")) {
      Object obj = map.get("trade_no2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeNo2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_name")) {
      Object obj = map.get("warehouse_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_no")) {
      Object obj = map.get("warehouse_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_id")) {
      Object obj = map.get("logistic_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logisticlist_no")) {
      Object obj = map.get("logisticlist_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticlistNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_name")) {
      Object obj = map.get("logistic_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("post_id")) {
      Object obj = map.get("post_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPostId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_total")) {
      Object obj = map.get("goods_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("postage_total")) {
      Object obj = map.get("postage_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostageTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostageTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostageTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostageTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostageTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_value")) {
      Object obj = map.get("tax_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("coupon_value")) {
      Object obj = map.get("coupon_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCouponValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCouponValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCouponValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCouponValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCouponValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("favourable_total")) {
      Object obj = map.get("favourable_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFavourableTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFavourableTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFavourableTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFavourableTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFavourableTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("all_total")) {
      Object obj = map.get("all_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAllTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAllTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAllTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAllTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAllTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rcv_total")) {
      Object obj = map.get("rcv_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRcvTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRcvTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRcvTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRcvTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRcvTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_cost")) {
      Object obj = map.get("goods_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_weight")) {
      Object obj = map.get("goods_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("other_cost")) {
      Object obj = map.get("other_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOtherCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOtherCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOtherCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOtherCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOtherCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_profit")) {
      Object obj = map.get("total_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("commission_value")) {
      Object obj = map.get("commission_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCommissionValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCommissionValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCommissionValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCommissionValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCommissionValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customer_remark")) {
      Object obj = map.get("customer_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cancel_reason")) {
      Object obj = map.get("cancel_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCancelReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confirm_time")) {
      Object obj = map.get("confirm_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConfirmTime(null);
      }
    }
    if(map.containsKey("confirm_operator")) {
      Object obj = map.get("confirm_operator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConfirmOperator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("snd_time")) {
      Object obj = map.get("snd_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSndTime(null);
      }
    }
    if(map.containsKey("snd_operator")) {
      Object obj = map.get("snd_operator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSndOperator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_title")) {
      Object obj = map.get("invoice_title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bin_voice")) {
      Object obj = map.get("bin_voice");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBinVoice((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBinVoice(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBinVoice(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("postage")) {
      Object obj = map.get("postage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_type")) {
      Object obj = map.get("shop_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_type")) {
      Object obj = map.get("charge_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_id")) {
      Object obj = map.get("customer_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTown((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zip")) {
      Object obj = map.get("zip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZip((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved4")) {
      Object obj = map.get("reserved4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_id")) {
      Object obj = map.get("charge_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chk_operator")) {
      Object obj = map.get("chk_operator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChkOperator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency_rate")) {
      Object obj = map.get("currency_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCurrencyRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCurrencyRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCurrencyRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCurrencyRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCurrencyRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("currency_type")) {
      Object obj = map.get("currency_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrencyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeze_reason")) {
      Object obj = map.get("freeze_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreezeReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packaged_weight")) {
      Object obj = map.get("packaged_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackagedWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackagedWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackagedWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackagedWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackagedWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_operator")) {
      Object obj = map.get("package_operator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageOperator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("picker")) {
      Object obj = map.get("picker");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPicker((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("provider_id")) {
      Object obj = map.get("provider_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProviderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("provider_name")) {
      Object obj = map.get("provider_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProviderName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("provider_no")) {
      Object obj = map.get("provider_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProviderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_from")) {
      Object obj = map.get("trade_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flag_name")) {
      Object obj = map.get("flag_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlagName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_payer_phone")) {
      Object obj = map.get("invoice_payer_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicePayerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_payer_addr")) {
      Object obj = map.get("invoice_payer_addr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicePayerAddr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_payer_bank_no")) {
      Object obj = map.get("invoice_payer_bank_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicePayerBankNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_payer_reg_no")) {
      Object obj = map.get("invoice_payer_reg_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicePayerRegNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("package_name")) {
      Object obj = map.get("package_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tel")) {
      Object obj = map.get("tel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("snd_to")) {
      Object obj = map.get("snd_to");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSndTo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_nick")) {
      Object obj = map.get("trade_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("adr")) {
      Object obj = map.get("adr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAdr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("card_type")) {
      Object obj = map.get("card_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCardType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id_card")) {
      Object obj = map.get("id_card");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIdCard((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("card_name")) {
      Object obj = map.get("card_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCardName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_create_time")) {
      Object obj = map.get("oms_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOmsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOmsCreateTime(null);
      }
    }
    if(map.containsKey("oms_update_time")) {
      Object obj = map.get("oms_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOmsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOmsUpdateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chk_time")) {
      Object obj = map.get("chk_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChkTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("predate")) {
      Object obj = map.get("predate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPredate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkAmount")) {
      Object obj = map.get("checkAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("oms_id")) {
      Object obj = map.get("oms_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOmsId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reg_time")) {
      Object obj = map.get("reg_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRegTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRegTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRegTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRegTime(null);
      }
    }
    if(map.containsKey("reg_operator")) {
      Object obj = map.get("reg_operator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegOperator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_time")) {
      Object obj = map.get("trade_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTradeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTradeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTradeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTradeTime(null);
      }
    }
    if(map.containsKey("trade_status")) {
      Object obj = map.get("trade_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_no")) {
      Object obj = map.get("trade_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouse_id")) {
      Object obj = map.get("warehouse_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeller((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_no2")) {
      Object obj = map.get("trade_no2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeNo2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouse_name")) {
      Object obj = map.get("warehouse_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouse_no")) {
      Object obj = map.get("warehouse_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistic_id")) {
      Object obj = map.get("logistic_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logisticlist_no")) {
      Object obj = map.get("logisticlist_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticlistNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistic_name")) {
      Object obj = map.get("logistic_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("post_id")) {
      Object obj = map.get("post_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPostId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_total")) {
      Object obj = map.get("goods_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("postage_total")) {
      Object obj = map.get("postage_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostageTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostageTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostageTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostageTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostageTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_value")) {
      Object obj = map.get("tax_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("coupon_value")) {
      Object obj = map.get("coupon_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCouponValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCouponValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCouponValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCouponValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCouponValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("favourable_total")) {
      Object obj = map.get("favourable_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFavourableTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFavourableTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFavourableTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFavourableTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFavourableTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("all_total")) {
      Object obj = map.get("all_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAllTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAllTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAllTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAllTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAllTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rcv_total")) {
      Object obj = map.get("rcv_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRcvTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRcvTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRcvTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRcvTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRcvTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goods_cost")) {
      Object obj = map.get("goods_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goods_weight")) {
      Object obj = map.get("goods_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("other_cost")) {
      Object obj = map.get("other_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOtherCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOtherCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOtherCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOtherCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOtherCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total_profit")) {
      Object obj = map.get("total_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("commission_value")) {
      Object obj = map.get("commission_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCommissionValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCommissionValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCommissionValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCommissionValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCommissionValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customer_remark")) {
      Object obj = map.get("customer_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cancel_reason")) {
      Object obj = map.get("cancel_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCancelReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("confirm_time")) {
      Object obj = map.get("confirm_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setConfirmTime(null);
      }
    }
    if(map.containsKey("confirm_operator")) {
      Object obj = map.get("confirm_operator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfirmOperator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("snd_time")) {
      Object obj = map.get("snd_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSndTime(null);
      }
    }
    if(map.containsKey("snd_operator")) {
      Object obj = map.get("snd_operator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSndOperator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_title")) {
      Object obj = map.get("invoice_title");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceTitle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bin_voice")) {
      Object obj = map.get("bin_voice");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBinVoice((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBinVoice(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBinVoice(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("postage")) {
      Object obj = map.get("postage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shop_type")) {
      Object obj = map.get("shop_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_type")) {
      Object obj = map.get("charge_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_id")) {
      Object obj = map.get("customer_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTown((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zip")) {
      Object obj = map.get("zip");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZip((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserved1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserved2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserved3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved4")) {
      Object obj = map.get("reserved4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserved4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_id")) {
      Object obj = map.get("charge_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chk_operator")) {
      Object obj = map.get("chk_operator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChkOperator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency_rate")) {
      Object obj = map.get("currency_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCurrencyRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCurrencyRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCurrencyRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCurrencyRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCurrencyRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("currency_type")) {
      Object obj = map.get("currency_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrencyType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freeze_reason")) {
      Object obj = map.get("freeze_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFreezeReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packaged_weight")) {
      Object obj = map.get("packaged_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackagedWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackagedWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackagedWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackagedWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackagedWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("package_operator")) {
      Object obj = map.get("package_operator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageOperator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("picker")) {
      Object obj = map.get("picker");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPicker((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("provider_id")) {
      Object obj = map.get("provider_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProviderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("provider_name")) {
      Object obj = map.get("provider_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProviderName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("provider_no")) {
      Object obj = map.get("provider_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProviderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_from")) {
      Object obj = map.get("trade_from");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flag_name")) {
      Object obj = map.get("flag_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlagName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_payer_phone")) {
      Object obj = map.get("invoice_payer_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicePayerPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_payer_addr")) {
      Object obj = map.get("invoice_payer_addr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicePayerAddr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_payer_bank_no")) {
      Object obj = map.get("invoice_payer_bank_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicePayerBankNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_payer_reg_no")) {
      Object obj = map.get("invoice_payer_reg_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicePayerRegNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("package_name")) {
      Object obj = map.get("package_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tel")) {
      Object obj = map.get("tel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("snd_to")) {
      Object obj = map.get("snd_to");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSndTo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_nick")) {
      Object obj = map.get("trade_nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("adr")) {
      Object obj = map.get("adr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAdr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("card_type")) {
      Object obj = map.get("card_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCardType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id_card")) {
      Object obj = map.get("id_card");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIdCard((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("card_name")) {
      Object obj = map.get("card_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCardName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oms_create_time")) {
      Object obj = map.get("oms_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOmsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOmsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOmsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOmsCreateTime(null);
      }
    }
    if(map.containsKey("oms_update_time")) {
      Object obj = map.get("oms_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOmsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOmsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOmsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOmsUpdateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataSource")) {
      Object obj = map.get("dataSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chk_time")) {
      Object obj = map.get("chk_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChkTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("predate")) {
      Object obj = map.get("predate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPredate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkAmount")) {
      Object obj = map.get("checkAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
