package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TbSalesOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 淘宝ID
   */
  private Long tbId;

  /**
   * 租户code
   */
  private String tbTenantCode;

  /**
   * 店铺id
   */
  private String storeId;

  /**
   * 订单编号
   */
  private String orderNo;

  /**
   * 支付单号
   */
  private String payOrderNo;

  /**
   * 支付详情
   */
  private String payDetail;

  /**
   * 买家应付货款
   */
  private BigDecimal buyerPayable;

  /**
   * 买家应付邮费
   */
  private BigDecimal buyerPostFee;

  /**
   * 总金额
   */
  private BigDecimal totalAmount;

  /**
   * 返点积分
   */
  private Long returnPoint;

  /**
   * 买家实付金额
   */
  private BigDecimal buyerRealPay;

  /**
   * 买家实付积分
   */
  private Long buyerRealPoint;

  /**
   * 买家留言
   */
  private String buyerMessage;

  /**
   * 收货地址
   */
  private String receiverAddress;

  /**
   * 运送方式
   */
  private String deliveryType;

  /**
   * 订单创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderCreateTime;

  /**
   * 订单付款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderPayTime;

  /**
   * 商品标题
   */
  private String goodsTitle;

  /**
   * 宝贝种类
   */
  private String treasureType;

  /**
   * 物流单号
   */
  private String logisticsNo;

  /**
   * 物流公司
   */
  private String logisticsCompany;

  /**
   * 备注标签
   */
  private String remarkTag;

  /**
   * 商家备注
   */
  private String merchantRemark;

  /**
   * 宝贝总数量
   */
  private Long treasureCount;

  /**
   * 店铺ID
   */
  private String shopId;

  /**
   * 店铺名称
   */
  private String shopName;

  /**
   * 订单关闭原因
   */
  private String orderCloseReason;

  /**
   * 卖家服务费
   */
  private BigDecimal sellerServiceFee;

  /**
   * 买家服务费
   */
  private BigDecimal buyerServiceFee;

  /**
   * 开票信息
   */
  private String invoiceInfo;

  /**
   * 手机订单
   */
  private String phoneOrder;

  /**
   * 分阶段信息
   */
  private String phaseInfo;

  /**
   * 退款金额
   */
  private BigDecimal refundAmount;

  /**
   * 是否主动赔付
   */
  private String activeCompensation;

  /**
   * 主动赔付金额
   */
  private BigDecimal activeCompensationAmount;

  /**
   * 主动赔付出账时间
   */
  private String activeCompensationTime;

  /**
   * 预售下沉订单
   */
  private String preSellSinkOrder;

  /**
   * 预售下沉状态
   */
  private String preSellSinkStatus;

  /**
   * 商品属性SKU
   */
  private String goodSkuInfo;

  /**
   * 安心鉴订单
   */
  private String reassureOrder;

  /**
   * 安心鉴订单二阶段物流
   */
  private String reassureTwoLogistics;

  /**
   * 百亿补贴HOLD单
   */
  private String tenBillionSubsidies;

  /**
   * C2B小额收款
   */
  private String c2bSmallRev;

  /**
   * 淘鲜达渠道
   */
  private String taoxdChannel;

  /**
   * 预售订单
   */
  private String preSellOrder;

  /**
   * 发货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryTime;

  /**
   * 确认收货打款金额
   */
  private BigDecimal confirmReceiveAmount;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 单据流转状态
   */
  private String dealStatus;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 对账状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 获取账单日期
   */
  private String acqBillDate;

  /**
   * 应发货时间
   */
  private String shouldDeliveryTime;

  /**
   * 订单状态
   */
  private String orderStatus;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tb_id", tbId);
      map.put("tb_tenant_code", tbTenantCode);
      map.put("store_id", storeId);
      map.put("order_no", orderNo);
      map.put("pay_order_no", payOrderNo);
      map.put("pay_detail", payDetail);
      map.put("buyer_payable", buyerPayable);
      map.put("buyer_post_fee", buyerPostFee);
      map.put("total_amount", totalAmount);
      map.put("return_point", returnPoint);
      map.put("buyer_real_pay", buyerRealPay);
      map.put("buyer_real_point", buyerRealPoint);
      map.put("buyer_message", buyerMessage);
      map.put("receiver_address", receiverAddress);
      map.put("delivery_type", deliveryType);
      map.put("order_create_time", BocpGenUtils.toTimestamp(orderCreateTime));
      map.put("order_pay_time", BocpGenUtils.toTimestamp(orderPayTime));
      map.put("goods_title", goodsTitle);
      map.put("treasure_type", treasureType);
      map.put("logistics_no", logisticsNo);
      map.put("logistics_company", logisticsCompany);
      map.put("remark_tag", remarkTag);
      map.put("merchant_remark", merchantRemark);
      map.put("treasure_count", treasureCount);
      map.put("shop_id", shopId);
      map.put("shop_name", shopName);
      map.put("order_close_reason", orderCloseReason);
      map.put("seller_service_fee", sellerServiceFee);
      map.put("buyer_service_fee", buyerServiceFee);
      map.put("invoice_info", invoiceInfo);
      map.put("phone_order", phoneOrder);
      map.put("phase_info", phaseInfo);
      map.put("refund_amount", refundAmount);
      map.put("active_compensation", activeCompensation);
      map.put("active_compensation_amount", activeCompensationAmount);
      map.put("active_compensation_time", activeCompensationTime);
      map.put("pre_sell_sink_order", preSellSinkOrder);
      map.put("pre_sell_sink_status", preSellSinkStatus);
      map.put("good_sku_info", goodSkuInfo);
      map.put("reassure_order", reassureOrder);
      map.put("reassure_two_logistics", reassureTwoLogistics);
      map.put("ten_billion_subsidies", tenBillionSubsidies);
      map.put("c2b_small_rev", c2bSmallRev);
      map.put("taoxd_channel", taoxdChannel);
      map.put("pre_sell_order", preSellOrder);
      map.put("delivery_time", BocpGenUtils.toTimestamp(deliveryTime));
      map.put("confirm_receive_amount", confirmReceiveAmount);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("business_id", businessId);
      map.put("deal_status", dealStatus);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("checkStatus", checkStatus);
      map.put("acq_bill_date", acqBillDate);
      map.put("should_delivery_time", shouldDeliveryTime);
      map.put("order_status", orderStatus);
      map.put("org_tree", orgTree);

      return map;
  }

  public static TbSalesOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TbSalesOrder entity = new TbSalesOrder();
    if(map.containsKey("tb_id")) {
      Object obj = map.get("tb_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTbId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTbId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTbId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tb_tenant_code")) {
      Object obj = map.get("tb_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTbTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_order_no")) {
      Object obj = map.get("pay_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_detail")) {
      Object obj = map.get("pay_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_payable")) {
      Object obj = map.get("buyer_payable");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBuyerPayable((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBuyerPayable(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBuyerPayable(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerPayable(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerPayable(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyer_post_fee")) {
      Object obj = map.get("buyer_post_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBuyerPostFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBuyerPostFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBuyerPostFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerPostFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerPostFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("return_point")) {
      Object obj = map.get("return_point");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReturnPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReturnPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("buyer_real_pay")) {
      Object obj = map.get("buyer_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBuyerRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBuyerRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBuyerRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyer_real_point")) {
      Object obj = map.get("buyer_real_point");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBuyerRealPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerRealPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerRealPoint(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("buyer_message")) {
      Object obj = map.get("buyer_message");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiver_address")) {
      Object obj = map.get("receiver_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiverAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_type")) {
      Object obj = map.get("delivery_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_create_time")) {
      Object obj = map.get("order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderCreateTime(null);
      }
    }
    if(map.containsKey("order_pay_time")) {
      Object obj = map.get("order_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderPayTime(null);
      }
    }
    if(map.containsKey("goods_title")) {
      Object obj = map.get("goods_title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("treasure_type")) {
      Object obj = map.get("treasure_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTreasureType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_no")) {
      Object obj = map.get("logistics_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_company")) {
      Object obj = map.get("logistics_company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark_tag")) {
      Object obj = map.get("remark_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemarkTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("treasure_count")) {
      Object obj = map.get("treasure_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTreasureCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTreasureCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTreasureCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_close_reason")) {
      Object obj = map.get("order_close_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderCloseReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_service_fee")) {
      Object obj = map.get("seller_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellerServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellerServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellerServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("buyer_service_fee")) {
      Object obj = map.get("buyer_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBuyerServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBuyerServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBuyerServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_info")) {
      Object obj = map.get("invoice_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phone_order")) {
      Object obj = map.get("phone_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPhoneOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phase_info")) {
      Object obj = map.get("phase_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPhaseInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation")) {
      Object obj = map.get("active_compensation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActiveCompensation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation_amount")) {
      Object obj = map.get("active_compensation_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActiveCompensationAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActiveCompensationAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActiveCompensationAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActiveCompensationAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActiveCompensationAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("active_compensation_time")) {
      Object obj = map.get("active_compensation_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActiveCompensationTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pre_sell_sink_order")) {
      Object obj = map.get("pre_sell_sink_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreSellSinkOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pre_sell_sink_status")) {
      Object obj = map.get("pre_sell_sink_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreSellSinkStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("good_sku_info")) {
      Object obj = map.get("good_sku_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodSkuInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reassure_order")) {
      Object obj = map.get("reassure_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReassureOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reassure_two_logistics")) {
      Object obj = map.get("reassure_two_logistics");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReassureTwoLogistics((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ten_billion_subsidies")) {
      Object obj = map.get("ten_billion_subsidies");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenBillionSubsidies((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("c2b_small_rev")) {
      Object obj = map.get("c2b_small_rev");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setC2bSmallRev((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taoxd_channel")) {
      Object obj = map.get("taoxd_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaoxdChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pre_sell_order")) {
      Object obj = map.get("pre_sell_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreSellOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delivery_time")) {
      Object obj = map.get("delivery_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeliveryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryTime(null);
      }
    }
    if(map.containsKey("confirm_receive_amount")) {
      Object obj = map.get("confirm_receive_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setConfirmReceiveAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setConfirmReceiveAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setConfirmReceiveAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfirmReceiveAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setConfirmReceiveAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAcqBillDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("should_delivery_time")) {
      Object obj = map.get("should_delivery_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShouldDeliveryTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("tb_id")) {
      Object obj = map.get("tb_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTbId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTbId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTbId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tb_tenant_code")) {
      Object obj = map.get("tb_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTbTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_order_no")) {
      Object obj = map.get("pay_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_detail")) {
      Object obj = map.get("pay_detail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_payable")) {
      Object obj = map.get("buyer_payable");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBuyerPayable((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBuyerPayable(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBuyerPayable(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuyerPayable(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBuyerPayable(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("buyer_post_fee")) {
      Object obj = map.get("buyer_post_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBuyerPostFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBuyerPostFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBuyerPostFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuyerPostFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBuyerPostFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("return_point")) {
      Object obj = map.get("return_point");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReturnPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReturnPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setReturnPoint(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("buyer_real_pay")) {
      Object obj = map.get("buyer_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBuyerRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBuyerRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBuyerRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuyerRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBuyerRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("buyer_real_point")) {
      Object obj = map.get("buyer_real_point");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBuyerRealPoint((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuyerRealPoint(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBuyerRealPoint(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("buyer_message")) {
      Object obj = map.get("buyer_message");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiver_address")) {
      Object obj = map.get("receiver_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delivery_type")) {
      Object obj = map.get("delivery_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_create_time")) {
      Object obj = map.get("order_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderCreateTime(null);
      }
    }
    if(map.containsKey("order_pay_time")) {
      Object obj = map.get("order_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderPayTime(null);
      }
    }
    if(map.containsKey("goods_title")) {
      Object obj = map.get("goods_title");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTitle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("treasure_type")) {
      Object obj = map.get("treasure_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTreasureType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_no")) {
      Object obj = map.get("logistics_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_company")) {
      Object obj = map.get("logistics_company");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark_tag")) {
      Object obj = map.get("remark_tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemarkTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMerchantRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("treasure_count")) {
      Object obj = map.get("treasure_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTreasureCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTreasureCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTreasureCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_close_reason")) {
      Object obj = map.get("order_close_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderCloseReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_service_fee")) {
      Object obj = map.get("seller_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSellerServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSellerServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSellerServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("buyer_service_fee")) {
      Object obj = map.get("buyer_service_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBuyerServiceFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBuyerServiceFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBuyerServiceFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuyerServiceFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBuyerServiceFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_info")) {
      Object obj = map.get("invoice_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("phone_order")) {
      Object obj = map.get("phone_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPhoneOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("phase_info")) {
      Object obj = map.get("phase_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPhaseInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("active_compensation")) {
      Object obj = map.get("active_compensation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActiveCompensation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("active_compensation_amount")) {
      Object obj = map.get("active_compensation_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActiveCompensationAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActiveCompensationAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActiveCompensationAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActiveCompensationAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActiveCompensationAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("active_compensation_time")) {
      Object obj = map.get("active_compensation_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActiveCompensationTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pre_sell_sink_order")) {
      Object obj = map.get("pre_sell_sink_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreSellSinkOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pre_sell_sink_status")) {
      Object obj = map.get("pre_sell_sink_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreSellSinkStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("good_sku_info")) {
      Object obj = map.get("good_sku_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodSkuInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reassure_order")) {
      Object obj = map.get("reassure_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReassureOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reassure_two_logistics")) {
      Object obj = map.get("reassure_two_logistics");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReassureTwoLogistics((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ten_billion_subsidies")) {
      Object obj = map.get("ten_billion_subsidies");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenBillionSubsidies((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("c2b_small_rev")) {
      Object obj = map.get("c2b_small_rev");
      if(obj != null) {
        if(obj instanceof String) {
          this.setC2bSmallRev((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taoxd_channel")) {
      Object obj = map.get("taoxd_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaoxdChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pre_sell_order")) {
      Object obj = map.get("pre_sell_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreSellOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delivery_time")) {
      Object obj = map.get("delivery_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeliveryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeliveryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeliveryTime(null);
      }
    }
    if(map.containsKey("confirm_receive_amount")) {
      Object obj = map.get("confirm_receive_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setConfirmReceiveAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setConfirmReceiveAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setConfirmReceiveAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConfirmReceiveAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setConfirmReceiveAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAcqBillDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("should_delivery_time")) {
      Object obj = map.get("should_delivery_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShouldDeliveryTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
