package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_arbitrate_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-21
 */
public enum DyArbitrateStatus {

    _0("0", "无仲裁记录"),
    _1("1", "仲裁中"),
    _2("2", "客服同意"),
    _3("3", "客服拒绝"),
    _4("4", "待商家举证"),
    _5("5", "协商期"),
    _255("255", "仲裁结束");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyArbitrateStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyArbitrateStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "255":
                return _255;
            default:
                return null;
        }
    }
}
