package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_refund_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-21
 */
public enum DyRefundType {

    _1("1", "极速退款助手"),
    _2("2", "售后小助手"),
    _3("3", "售后极速退"),
    _4("4", "闪电退货"),
    _0("0", "--");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyRefundType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyRefundType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
