package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_is_bill_check
 * </p>
 *
 * @author ultraman
 * @since 2024-11-21
 */
public enum JkyIsBillCheck {

    _1("1", "对账"),
    其他("其他", "未对账");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JkyIsBillCheck(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyIsBillCheck fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "其他":
                return 其他;
            default:
                return null;
        }
    }
}
