package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_channel
 * </p>
 *
 * @author ultraman
 * @since 2024-11-21
 */
public enum OmsChannel {

    JKY("jky", "吉客云"),
    WDGJ("wdgj", "网店管家");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OmsChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsChannel fromCode(String code){
        switch(code) {
            case "jky":
                return JKY;
            case "wdgj":
                return WDGJ;
            default:
                return null;
        }
    }
}
