package com.xforceplus.ultraman.app.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_stock_out_handle_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-21
 */
public enum PddStockOutHandleStatus {

    __1("-1", "无缺货处理"),
    _0("0", "缺货待处理"),
    _1("1", "缺货已处理");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PddStockOutHandleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddStockOutHandleStatus fromCode(String code){
        switch(code) {
            case "-1":
                return __1;
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
