package com.xforceplus.ultraman.app.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CollectionSummary implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 店铺名称
   */
  private String shopName;

  /**
   * 收入金额
   */
  private BigDecimal receiveAmount;

  /**
   * 支出金额
   */
  private BigDecimal payAmount;

  /**
   * 店铺编号
   */
  private String shopId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 汇总收款单号
   */
  private String sumCollectionOrderId;

  /**
   * 收款单类型
   */
  private String collectionOrderType;

  /**
   * 记账类型
   */
  private String accountType;

  /**
   * 核销状态
   */
  private String writeoffStatus;

  /**
   * 汇总金额
   */
  private BigDecimal sumAmount;

  /**
   * 记账状态
   */
  private String accountStatus;

  /**
   * 电商渠道
   */
  private String ecChannel;

  /**
   * 事业部名称
   */
  private String bussinessUnitName;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String companyTaxNo;

  /**
   * 数据来源类型
   */
  private String dataResourceType;

  /**
   * 入账类型
   */
  @TableField("incomeType")
  private String incomeType;

  /**
   * 作废状态
   */
  private String validStatus;

  /**
   * 汇总日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime summaryDate;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * EBS回传状态
   */
  private String ebsBackStatus;

  /**
   * 账期
   */
  private String accountPeriod;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 人工备注
   */
  @TableField("manualRemark")
  private String manualRemark;

  /**
   * 凭证编号
   */
  private String documentNo;

  /**
   * 凭证日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentDate;

  /**
   * EBS冲销状态
   */
  private String reversalDocumentStatus;

  /**
   * 冲销凭证编号
   */
  private String reversalDocumentNo;

  /**
   * 冲销凭证日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reversalDocumentDate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("shop_name", shopName);
      map.put("receive_amount", receiveAmount);
      map.put("pay_amount", payAmount);
      map.put("shop_id", shopId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sum_collection_order_id", sumCollectionOrderId);
      map.put("collection_order_type", collectionOrderType);
      map.put("account_type", accountType);
      map.put("writeoff_status", writeoffStatus);
      map.put("sum_amount", sumAmount);
      map.put("account_status", accountStatus);
      map.put("ec_channel", ecChannel);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("data_resource_type", dataResourceType);
      map.put("incomeType", incomeType);
      map.put("valid_status", validStatus);
      map.put("summary_date", BocpGenUtils.toTimestamp(summaryDate));
      map.put("error_msg", errorMsg);
      map.put("ebs_back_status", ebsBackStatus);
      map.put("account_period", accountPeriod);
      map.put("invoice_no", invoiceNo);
      map.put("manualRemark", manualRemark);
      map.put("document_no", documentNo);
      map.put("document_date", BocpGenUtils.toTimestamp(documentDate));
      map.put("reversal_document_status", reversalDocumentStatus);
      map.put("reversal_document_no", reversalDocumentNo);
      map.put("reversal_document_date", BocpGenUtils.toTimestamp(reversalDocumentDate));

      return map;
  }

  public static CollectionSummary fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CollectionSummary entity = new CollectionSummary();
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receive_amount")) {
      Object obj = map.get("receive_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceiveAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceiveAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceiveAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceiveAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiveAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sum_collection_order_id")) {
      Object obj = map.get("sum_collection_order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSumCollectionOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_order_type")) {
      Object obj = map.get("collection_order_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_type")) {
      Object obj = map.get("account_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("writeoff_status")) {
      Object obj = map.get("writeoff_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWriteoffStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sum_amount")) {
      Object obj = map.get("sum_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSumAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSumAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSumAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSumAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSumAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("account_status")) {
      Object obj = map.get("account_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEcChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_resource_type")) {
      Object obj = map.get("data_resource_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataResourceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIncomeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("valid_status")) {
      Object obj = map.get("valid_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setValidStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("summary_date")) {
      Object obj = map.get("summary_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSummaryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSummaryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSummaryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSummaryDate(null);
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ebs_back_status")) {
      Object obj = map.get("ebs_back_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEbsBackStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("manualRemark")) {
      Object obj = map.get("manualRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManualRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_no")) {
      Object obj = map.get("document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("document_date")) {
      Object obj = map.get("document_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentDate(null);
      }
    }
    if(map.containsKey("reversal_document_status")) {
      Object obj = map.get("reversal_document_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReversalDocumentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reversal_document_no")) {
      Object obj = map.get("reversal_document_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReversalDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reversal_document_date")) {
      Object obj = map.get("reversal_document_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReversalDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReversalDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReversalDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReversalDocumentDate(null);
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receive_amount")) {
      Object obj = map.get("receive_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceiveAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceiveAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceiveAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceiveAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceiveAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sum_collection_order_id")) {
      Object obj = map.get("sum_collection_order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSumCollectionOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collection_order_type")) {
      Object obj = map.get("collection_order_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_type")) {
      Object obj = map.get("account_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("writeoff_status")) {
      Object obj = map.get("writeoff_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWriteoffStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sum_amount")) {
      Object obj = map.get("sum_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSumAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSumAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSumAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSumAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSumAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("account_status")) {
      Object obj = map.get("account_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ec_channel")) {
      Object obj = map.get("ec_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussinessUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("data_resource_type")) {
      Object obj = map.get("data_resource_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataResourceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("incomeType")) {
      Object obj = map.get("incomeType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIncomeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("valid_status")) {
      Object obj = map.get("valid_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValidStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("summary_date")) {
      Object obj = map.get("summary_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSummaryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSummaryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSummaryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSummaryDate(null);
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ebs_back_status")) {
      Object obj = map.get("ebs_back_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEbsBackStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("manualRemark")) {
      Object obj = map.get("manualRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManualRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("document_no")) {
      Object obj = map.get("document_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("document_date")) {
      Object obj = map.get("document_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDocumentDate(null);
      }
    }
    if(map.containsKey("reversal_document_status")) {
      Object obj = map.get("reversal_document_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReversalDocumentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reversal_document_no")) {
      Object obj = map.get("reversal_document_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReversalDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reversal_document_date")) {
      Object obj = map.get("reversal_document_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReversalDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReversalDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReversalDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReversalDocumentDate(null);
      }
    }
  }
}
